/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.XmlRpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.XmlRpcResponse;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcEventListener;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcResponseHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlRpcServer
implements RpcServer {
    private final Logger logger = LoggerFactory.getLogger(XmlRpcServer.class);
    private static final String XML_EMPTY_STRING = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<methodResponse><params><param><value></value></param></params></methodResponse>";
    private static final String XML_EMPTY_ARRAY = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<methodResponse><params><param><value><array><data></data></array></value></param></params></methodResponse>";
    private static final String XML_EMPTY_EVENT_LIST = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<methodResponse><params><param><value><array><data><value>event</value></data></array></value></param></params></methodResponse>";
    private Server xmlRpcHTTPD;
    private HomematicConfig config;
    private RpcResponseHandler<String> rpcResponseHander;
    private final ResponseHandler jettyResponseHandler = new ResponseHandler();

    public XmlRpcServer(RpcEventListener listener, HomematicConfig config) {
        this.config = config;
        this.rpcResponseHander = new RpcResponseHandler<String>(listener){

            @Override
            protected String getEmptyStringResult() {
                return XmlRpcServer.XML_EMPTY_STRING;
            }

            @Override
            protected String getEmptyEventListResult() {
                return XmlRpcServer.XML_EMPTY_EVENT_LIST;
            }

            @Override
            protected String getEmptyArrayResult() {
                return XmlRpcServer.XML_EMPTY_ARRAY;
            }

            @Override
            protected RpcRequest<String> createRpcRequest() {
                return new XmlRpcRequest(null, XmlRpcRequest.TYPE.RESPONSE);
            }
        };
    }

    @Override
    public void start() throws IOException {
        this.logger.debug("Initializing XML-RPC server at port {}", (Object)this.config.getXmlCallbackPort());
        InetSocketAddress callbackAddress = new InetSocketAddress(this.config.getCallbackHost(), this.config.getXmlCallbackPort());
        this.xmlRpcHTTPD = new Server(callbackAddress);
        this.xmlRpcHTTPD.setHandler((Handler)this.jettyResponseHandler);
        try {
            this.xmlRpcHTTPD.start();
            if (this.logger.isTraceEnabled()) {
                this.xmlRpcHTTPD.dumpStdErr();
            }
        }
        catch (Exception e) {
            throw new IOException("Jetty start failed", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.xmlRpcHTTPD != null) {
            this.logger.debug("Stopping XML-RPC server");
            try {
                this.xmlRpcHTTPD.stop();
            }
            catch (Exception ex) {
                this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    private class ResponseHandler
    extends AbstractHandler {
        private ResponseHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/xml;charset=ISO-8859-1");
            response.setStatus(200);
            PrintWriter respWriter = response.getWriter();
            try {
                XmlRpcResponse xmlResponse = new XmlRpcResponse((InputStream)request.getInputStream(), XmlRpcServer.this.config.getEncoding());
                if (XmlRpcServer.this.logger.isTraceEnabled()) {
                    XmlRpcServer.this.logger.trace("Server parsed XmlRpcMessage:\n{}", (Object)xmlResponse);
                }
                String returnValue = (String)XmlRpcServer.this.rpcResponseHander.handleMethodCall(xmlResponse.getMethodName(), xmlResponse.getResponseData());
                if (XmlRpcServer.this.logger.isTraceEnabled()) {
                    XmlRpcServer.this.logger.trace("Server XmlRpcResponse:\n{}", (Object)returnValue);
                }
                respWriter.println(returnValue);
            }
            catch (ParserConfigurationException | SAXException ex) {
                XmlRpcServer.this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
                respWriter.println(XmlRpcServer.XML_EMPTY_STRING);
            }
            baseRequest.setHandled(true);
        }
    }
}

