/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter.type;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterTypeException;
import org.eclipse.smarthome.binding.homematic.internal.converter.StateInvertInfo;
import org.eclipse.smarthome.binding.homematic.internal.converter.TypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.OnOffTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.OpenClosedTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypeConverter<T extends State>
implements TypeConverter<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractTypeConverter.class);
    private static final List<StateInvertInfo> stateInvertDevices = new ArrayList<StateInvertInfo>(3);

    static {
        stateInvertDevices.add(new StateInvertInfo("HM-Sec-SC"));
        stateInvertDevices.add(new StateInvertInfo("ZEL-STG-RM-FFK"));
        stateInvertDevices.add(new StateInvertInfo("HM-Sec-TiS"));
        stateInvertDevices.add(new StateInvertInfo("HMW-IO-12-Sw14-DR", 15, 26));
        stateInvertDevices.add(new StateInvertInfo("BC-SC-Rd-WM"));
        stateInvertDevices.add(new StateInvertInfo("HM-SCI-3-FM"));
    }

    protected boolean isStateInvertDatapoint(HmDatapoint dp) {
        if ("STATE".equals(dp.getName())) {
            for (StateInvertInfo stateInvertInfo : stateInvertDevices) {
                if (!stateInvertInfo.isToInvert(dp)) continue;
                return true;
            }
        }
        return false;
    }

    protected BigDecimal round(Double number) {
        BigDecimal bd = new BigDecimal(number == null ? "0" : number.toString());
        String stringBd = bd.toPlainString();
        int scale = stringBd.length() - (stringBd.lastIndexOf(46) + 1);
        return bd.setScale(scale > 2 ? 6 : 2, RoundingMode.HALF_UP);
    }

    @Override
    public Object convertToBinding(Type type, HmDatapoint dp) throws ConverterException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Converting type {} with value '{}' to {} value with {} for '{}'", new Object[]{type.getClass().getSimpleName(), type.toString(), dp.getType(), this.getClass().getSimpleName(), new HmDatapointInfo(dp)});
        }
        if (type == UnDefType.NULL) {
            return null;
        }
        if (type.getClass().isEnum() && !(this instanceof OnOffTypeConverter) && !(this instanceof OpenClosedTypeConverter)) {
            return this.commandToBinding((Command)type, dp);
        }
        if (!this.toBindingValidation(dp, type.getClass())) {
            String errorMessage = String.format("Can't convert type %s with value '%s' to %s value with %s for '%s'", new Object[]{type.getClass().getSimpleName(), type.toString(), dp.getType(), this.getClass().getSimpleName(), new HmDatapointInfo(dp)});
            throw new ConverterTypeException(errorMessage);
        }
        return this.toBinding((State)type, dp);
    }

    @Override
    public T convertFromBinding(HmDatapoint dp) throws ConverterException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Converting {} value '{}' with {} for '{}'", new Object[]{dp.getType(), dp.getValue(), this.getClass().getSimpleName(), new HmDatapointInfo(dp)});
        }
        if (dp.getValue() == null) {
            return (T)UnDefType.NULL;
        }
        if (!this.fromBindingValidation(dp)) {
            String errorMessage = String.format("Can't convert %s value '%s' with %s for '%s'", new Object[]{dp.getType(), dp.getValue(), this.getClass().getSimpleName(), new HmDatapointInfo(dp)});
            throw new ConverterTypeException(errorMessage);
        }
        return this.fromBinding(dp);
    }

    protected Object commandToBinding(Command command, HmDatapoint dp) throws ConverterException {
        throw new ConverterException("Unsupported command " + command.getClass().getSimpleName() + " for " + this.getClass().getSimpleName());
    }

    protected abstract boolean toBindingValidation(HmDatapoint var1, Class<? extends Type> var2);

    protected abstract Object toBinding(T var1, HmDatapoint var2) throws ConverterException;

    protected abstract boolean fromBindingValidation(HmDatapoint var1);

    protected abstract T fromBinding(HmDatapoint var1) throws ConverterException;
}

