/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter.type;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.AbstractTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.types.Type;

public class QuantityTypeConverter
extends AbstractTypeConverter<QuantityType<? extends Quantity<?>>> {
    @Override
    protected boolean toBindingValidation(HmDatapoint dp, Class<? extends Type> typeClass) {
        return dp.isNumberType() && typeClass.isAssignableFrom(QuantityType.class);
    }

    @Override
    protected Object toBinding(QuantityType<? extends Quantity<?>> type, HmDatapoint dp) throws ConverterException {
        if (dp.isIntegerType()) {
            return this.toUnitFromDatapoint(type, dp).intValue();
        }
        return this.round(this.toUnitFromDatapoint(type, dp).doubleValue()).doubleValue();
    }

    private QuantityType<? extends Quantity<?>> toUnitFromDatapoint(QuantityType<? extends Quantity<?>> type, HmDatapoint dp) {
        if (dp == null || dp.getUnit() == null || dp.getUnit().isEmpty()) {
            return type;
        }
        switch (dp.getUnit()) {
            case "minutes": {
                return type.toUnit(SmartHomeUnits.MINUTE);
            }
            case "day": {
                return type.toUnit(SmartHomeUnits.DAY);
            }
            case "month": {
                return type.toUnit(SmartHomeUnits.YEAR.divide(12.0));
            }
            case "year": {
                return type.toUnit(SmartHomeUnits.YEAR);
            }
            case "Lux": {
                return type.toUnit(SmartHomeUnits.LUX);
            }
            case "degree": {
                return type.toUnit(SmartHomeUnits.DEGREE_ANGLE);
            }
        }
        return type.toUnit(dp.getUnit());
    }

    @Override
    protected boolean fromBindingValidation(HmDatapoint dp) {
        return dp.isNumberType() && dp.getValue() instanceof Number;
    }

    @Override
    protected QuantityType<? extends Quantity<?>> fromBinding(HmDatapoint dp) throws ConverterException {
        String unit;
        BigDecimal number = null;
        number = dp.isIntegerType() ? new BigDecimal(((Number)dp.getValue()).intValue()) : this.round(((Number)dp.getValue()).doubleValue());
        switch (unit = dp.getUnit() != null ? dp.getUnit() : "") {
            case "\u00b0C": {
                return new QuantityType((Number)number, SIUnits.CELSIUS);
            }
            case "V": {
                return new QuantityType((Number)number, SmartHomeUnits.VOLT);
            }
            case "%": {
                return new QuantityType((Number)number, SmartHomeUnits.PERCENT);
            }
            case "s": {
                return new QuantityType((Number)number, SmartHomeUnits.SECOND);
            }
            case "min": 
            case "minutes": {
                return new QuantityType((Number)number, SmartHomeUnits.MINUTE);
            }
            case "day": {
                return new QuantityType((Number)number, SmartHomeUnits.DAY);
            }
            case "month": {
                return new QuantityType((Number)number, SmartHomeUnits.YEAR.divide(12.0));
            }
            case "year": {
                return new QuantityType((Number)number, SmartHomeUnits.YEAR);
            }
            case "mHz": {
                return new QuantityType((Number)number, MetricPrefix.MILLI((Unit)SmartHomeUnits.HERTZ));
            }
            case "Hz": {
                return new QuantityType((Number)number, SmartHomeUnits.HERTZ);
            }
            case "hPa": {
                return new QuantityType((Number)number, SIUnits.PASCAL.multiply(2.0));
            }
            case "Lux": {
                return new QuantityType((Number)number, SmartHomeUnits.LUX);
            }
            case "degree": {
                return new QuantityType((Number)number, SmartHomeUnits.DEGREE_ANGLE);
            }
            case "km/h": {
                return new QuantityType((Number)number, SIUnits.KILOMETRE_PER_HOUR);
            }
            case "mm": {
                return new QuantityType((Number)number, MetricPrefix.MILLI((Unit)SIUnits.METRE));
            }
            case "W": {
                return new QuantityType((Number)number, SmartHomeUnits.WATT);
            }
            case "Wh": {
                return new QuantityType((Number)number, SmartHomeUnits.WATT_HOUR);
            }
            case "m3": {
                return new QuantityType((Number)number, SIUnits.CUBIC_METRE);
            }
        }
        return new QuantityType((Number)number, SmartHomeUnits.ONE);
    }
}

