/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.discovery;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.smarthome.binding.homematic.handler.HomematicBridgeHandler;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.type.UidUtils;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomematicDeviceDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(HomematicDeviceDiscoveryService.class);
    private static final int DISCOVER_TIMEOUT_SECONDS = 300;
    private final HomematicBridgeHandler bridgeHandler;
    private Future<?> loadDevicesFuture;
    private volatile boolean isInInstallMode = false;
    private volatile Object installModeSync = new Object();
    private volatile int installModeDuration = 60;

    public HomematicDeviceDiscoveryService(HomematicBridgeHandler bridgeHandler) {
        super(Collections.singleton(new ThingTypeUID("homematic", "-")), 300, false);
        this.bridgeHandler = bridgeHandler;
    }

    public void activate() {
        super.activate(null);
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void startScan() {
        this.logger.debug("Starting Homematic discovery scan");
        this.enableInstallMode();
        this.loadDevices();
    }

    private void enableInstallMode() {
        try {
            HomematicGateway gateway = this.bridgeHandler.getGateway();
            ThingStatus bridgeStatus = null;
            if (this.bridgeHandler != null) {
                Bridge bridge = this.bridgeHandler.getThing();
                bridgeStatus = bridge.getStatus();
                this.updateInstallModeDuration((Thing)bridge);
            }
            if (ThingStatus.ONLINE == bridgeStatus) {
                gateway.setInstallMode(true, this.installModeDuration);
                int remaining = gateway.getInstallMode();
                if (remaining > 0) {
                    this.setIsInInstallMode();
                    this.logger.debug("Successfully put controller in install mode. Remaining time: {} seconds", (Object)remaining);
                } else {
                    this.logger.warn("Controller did not accept requested install mode");
                }
            } else {
                this.logger.debug("Will not attempt to set controller in install mode, because bridge is not ONLINE.");
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to set Homematic controller in install mode", (Throwable)ex);
        }
    }

    private void updateInstallModeDuration(Thing bridge) {
        HomematicConfig config = (HomematicConfig)bridge.getConfiguration().as(HomematicConfig.class);
        this.installModeDuration = config.getInstallModeDuration();
    }

    public int getScanTimeout() {
        return this.installModeDuration;
    }

    public synchronized void stopScan() {
        this.logger.debug("Stopping Homematic discovery scan");
        if (this.bridgeHandler != null && this.bridgeHandler.getGateway() != null) {
            this.disableInstallMode();
            this.bridgeHandler.getGateway().cancelLoadAllDeviceMetadata();
        }
        this.waitForScanFinishing();
        super.stopScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableInstallMode() {
        try {
            Object object = this.installModeSync;
            synchronized (object) {
                if (this.isInInstallMode) {
                    this.isInInstallMode = false;
                    this.installModeSync.notify();
                    this.bridgeHandler.getGateway().setInstallMode(false, 0);
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to disable Homematic controller's install mode", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsInInstallMode() {
        Object object = this.installModeSync;
        synchronized (object) {
            this.isInInstallMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInstallModeFinished(int timeout) throws InterruptedException {
        Object object = this.installModeSync;
        synchronized (object) {
            while (this.isInInstallMode) {
                this.installModeSync.wait(timeout);
            }
        }
    }

    private void waitForLoadDevicesFinished() throws InterruptedException, ExecutionException {
        if (this.loadDevicesFuture != null) {
            this.loadDevicesFuture.get();
        }
    }

    public void waitForScanFinishing() {
        this.logger.debug("Waiting for finishing Homematic device discovery scan");
        try {
            this.waitForInstallModeFinished(300000);
            this.waitForLoadDevicesFinished();
        }
        catch (InterruptedException | ExecutionException exception) {
        }
        catch (Exception ex) {
            this.logger.error("Error waiting for device discovery scan: {}", (Object)ex.getMessage(), (Object)ex);
        }
        String gatewayId = this.bridgeHandler != null && this.bridgeHandler.getGateway() != null ? this.bridgeHandler.getGateway().getId() : "UNKNOWN";
        this.logger.debug("Finished Homematic device discovery scan on gateway '{}'", (Object)gatewayId);
    }

    public void loadDevices() {
        if (this.loadDevicesFuture == null && this.bridgeHandler.getGateway() != null) {
            this.loadDevicesFuture = this.scheduler.submit(() -> {
                try {
                    try {
                        HomematicGateway gateway = this.bridgeHandler.getGateway();
                        gateway.loadAllDeviceMetadata();
                        this.bridgeHandler.getTypeGenerator().validateFirmwares();
                    }
                    catch (Throwable ex) {
                        this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
                        this.loadDevicesFuture = null;
                        this.bridgeHandler.setOfflineStatus();
                        this.removeOlderResults(this.getTimestampOfLastScan());
                    }
                }
                finally {
                    this.loadDevicesFuture = null;
                    this.bridgeHandler.setOfflineStatus();
                    this.removeOlderResults(this.getTimestampOfLastScan());
                }
            });
        } else {
            this.logger.debug("Homematic devices discovery scan in progress");
        }
    }

    public void deviceRemoved(HmDevice device) {
        ThingUID thingUID = UidUtils.generateThingUID(device, this.bridgeHandler.getThing());
        this.thingRemoved(thingUID);
    }

    public void deviceDiscovered(HmDevice device) {
        ThingUID bridgeUID = this.bridgeHandler.getThing().getUID();
        ThingTypeUID typeUid = UidUtils.generateThingTypeUID(device);
        ThingUID thingUID = new ThingUID(typeUid, bridgeUID, device.getAddress());
        String label = device.getName() != null ? device.getName() : device.getAddress();
        long timeToLive = ((HomematicConfig)this.bridgeHandler.getThing().getConfiguration().as(HomematicConfig.class)).getDiscoveryTimeToLive();
        DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withBridge(bridgeUID).withLabel(label).withProperty("serialNumber", (Object)device.getAddress()).withRepresentationProperty("serialNumber").withTTL(timeToLive).build();
        this.thingDiscovered(discoveryResult);
    }
}

