/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicConfigDescriptionProvider;
import org.eclipse.smarthome.binding.homematic.type.HomematicThingTypeExcluder;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={HomematicConfigDescriptionProvider.class, ConfigDescriptionProvider.class}, immediate=true)
public class HomematicConfigDescriptionProviderImpl
implements HomematicConfigDescriptionProvider {
    private Map<URI, ConfigDescription> configDescriptionsByURI = new HashMap<URI, ConfigDescription>();
    protected List<HomematicThingTypeExcluder> homematicThingTypeExcluders = new CopyOnWriteArrayList<HomematicThingTypeExcluder>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.add(homematicThingTypeExcluder);
        }
    }

    protected void removeHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.remove(homematicThingTypeExcluder);
        }
    }

    private boolean isConfigDescriptionExcluded(URI configDescriptionURI) {
        for (HomematicThingTypeExcluder excluder : this.homematicThingTypeExcluders) {
            if (!excluder.isConfigDescriptionExcluded(configDescriptionURI)) continue;
            return true;
        }
        return false;
    }

    public Collection<ConfigDescription> getConfigDescriptions(Locale locale) {
        ArrayList<ConfigDescription> result = new ArrayList<ConfigDescription>();
        for (URI configDescriptionURI : this.configDescriptionsByURI.keySet()) {
            if (this.isConfigDescriptionExcluded(configDescriptionURI)) continue;
            result.add(this.configDescriptionsByURI.get(configDescriptionURI));
        }
        return result;
    }

    @Override
    public ConfigDescription getConfigDescription(URI uri, @Nullable Locale locale) {
        return this.isConfigDescriptionExcluded(uri) ? null : this.configDescriptionsByURI.get(uri);
    }

    @Override
    public ConfigDescription getInternalConfigDescription(URI uri) {
        return this.configDescriptionsByURI.get(uri);
    }

    @Override
    public void addConfigDescription(ConfigDescription configDescription) {
        this.configDescriptionsByURI.put(configDescription.getUID(), configDescription);
    }
}

