/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicThingTypeProvider;
import org.eclipse.smarthome.binding.homematic.type.HomematicThingTypeExcluder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={HomematicThingTypeProvider.class, ThingTypeProvider.class}, immediate=true)
public class HomematicThingTypeProviderImpl
implements HomematicThingTypeProvider {
    private Map<ThingTypeUID, ThingType> thingTypesByUID = new HashMap<ThingTypeUID, ThingType>();
    protected List<HomematicThingTypeExcluder> homematicThingTypeExcluders = new CopyOnWriteArrayList<HomematicThingTypeExcluder>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.add(homematicThingTypeExcluder);
        }
    }

    protected void removeHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.remove(homematicThingTypeExcluder);
        }
    }

    private Collection<ThingTypeUID> getExcludedThingTypes() {
        ArrayList<ThingTypeUID> thingTypes = new ArrayList<ThingTypeUID>();
        for (HomematicThingTypeExcluder excluder : this.homematicThingTypeExcluders) {
            thingTypes.addAll(excluder.getExcludedThingTypes());
        }
        return thingTypes;
    }

    private boolean isThingTypeExcluded(ThingTypeUID thingType) {
        for (HomematicThingTypeExcluder excluder : this.homematicThingTypeExcluders) {
            if (!excluder.isThingTypeExcluded(thingType)) continue;
            return true;
        }
        return false;
    }

    public Collection<ThingType> getThingTypes(Locale locale) {
        HashMap<ThingTypeUID, ThingType> copy = new HashMap<ThingTypeUID, ThingType>(this.thingTypesByUID);
        copy.keySet().removeAll(this.getExcludedThingTypes());
        return copy.values();
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID, Locale locale) {
        return this.isThingTypeExcluded(thingTypeUID) ? null : this.thingTypesByUID.get(thingTypeUID);
    }

    @Override
    public ThingType getInternalThingType(ThingTypeUID thingTypeUID) {
        return this.thingTypesByUID.get(thingTypeUID);
    }

    @Override
    public void addThingType(ThingType thingType) {
        this.thingTypesByUID.put(thingType.getUID(), thingType);
    }
}

