/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.smarthome.binding.homematic.HomematicBindingConstants;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicChannelGroupTypeProvider;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicChannelTypeProvider;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicConfigDescriptionProvider;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicThingTypeProvider;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicTypeGenerator;
import org.eclipse.smarthome.binding.homematic.internal.type.MetadataUtils;
import org.eclipse.smarthome.binding.homematic.internal.type.UidUtils;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.thing.DefaultSystemChannelTypeProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelDefinitionBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeBuilder;
import org.eclipse.smarthome.core.types.EventDescription;
import org.eclipse.smarthome.core.types.EventOption;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HomematicTypeGeneratorImpl
implements HomematicTypeGenerator {
    private final Logger logger = LoggerFactory.getLogger(HomematicTypeGeneratorImpl.class);
    private static URI configDescriptionUriChannel;
    private HomematicThingTypeProvider thingTypeProvider;
    private HomematicChannelTypeProvider channelTypeProvider;
    private HomematicChannelGroupTypeProvider channelGroupTypeProvider;
    private HomematicConfigDescriptionProvider configDescriptionProvider;
    private final Map<String, Set<String>> firmwaresByType = new HashMap<String, Set<String>>();
    private static final String[] STATUS_DATAPOINT_NAMES;
    private static final String[] IGNORE_DATAPOINT_NAMES;

    static {
        STATUS_DATAPOINT_NAMES = new String[]{"UNREACH", "CONFIG_PENDING", "DEVICE_IN_BOOTLOADER", "UPDATE_PENDING"};
        IGNORE_DATAPOINT_NAMES = new String[]{"AES_KEY", "RELOAD_FROM_GATEWAY"};
    }

    public HomematicTypeGeneratorImpl() {
        try {
            configDescriptionUriChannel = new URI("channel-type:homematic:config");
        }
        catch (Exception exception) {
            this.logger.warn("Can't create ConfigDescription URI '{}', ConfigDescription for channels not avilable!", (Object)"channel-type:homematic:config");
        }
    }

    @Reference
    protected void setThingTypeProvider(HomematicThingTypeProvider thingTypeProvider) {
        this.thingTypeProvider = thingTypeProvider;
    }

    protected void unsetThingTypeProvider(HomematicThingTypeProvider thingTypeProvider) {
        this.thingTypeProvider = null;
    }

    @Reference
    protected void setChannelTypeProvider(HomematicChannelTypeProvider channelTypeProvider) {
        this.channelTypeProvider = channelTypeProvider;
    }

    protected void unsetChannelTypeProvider(HomematicChannelTypeProvider channelTypeProvider) {
        this.channelTypeProvider = null;
    }

    @Reference
    protected void setChannelGroupTypeProvider(HomematicChannelGroupTypeProvider channelGroupTypeProvider) {
        this.channelGroupTypeProvider = channelGroupTypeProvider;
    }

    protected void unsetChannelGroupTypeProvider(HomematicChannelGroupTypeProvider channelGroupTypeProvider) {
        this.channelGroupTypeProvider = null;
    }

    @Reference
    protected void setConfigDescriptionProvider(HomematicConfigDescriptionProvider configDescriptionProvider) {
        this.configDescriptionProvider = configDescriptionProvider;
    }

    protected void unsetConfigDescriptionProvider(HomematicConfigDescriptionProvider configDescriptionProvider) {
        this.configDescriptionProvider = null;
    }

    @Override
    @Activate
    public void initialize() {
        MetadataUtils.initialize();
    }

    @Override
    public void generate(HmDevice device) {
        if (this.thingTypeProvider != null) {
            ThingTypeUID thingTypeUID = UidUtils.generateThingTypeUID(device);
            ThingType tt = this.thingTypeProvider.getInternalThingType(thingTypeUID);
            if (tt == null || device.isGatewayExtras()) {
                this.logger.debug("Generating ThingType for device '{}' with {} datapoints", (Object)device.getType(), (Object)device.getDatapointCount());
                ArrayList<ChannelGroupType> groupTypes = new ArrayList<ChannelGroupType>();
                for (HmChannel channel : device.getChannels()) {
                    ChannelGroupTypeUID groupTypeUID;
                    ChannelGroupType groupType;
                    ArrayList<ChannelDefinition> channelDefinitions = new ArrayList<ChannelDefinition>();
                    if (!channel.isReconfigurable()) {
                        for (HmDatapoint dp : channel.getDatapoints()) {
                            if (HomematicTypeGeneratorImpl.isIgnoredDatapoint(dp) || dp.getParamsetType() != HmParamsetType.VALUES) continue;
                            ChannelTypeUID channelTypeUID = UidUtils.generateChannelTypeUID(dp);
                            ChannelType channelType = this.channelTypeProvider.getInternalChannelType(channelTypeUID);
                            if (channelType == null) {
                                channelType = this.createChannelType(dp, channelTypeUID);
                                this.channelTypeProvider.addChannelType(channelType);
                            }
                            ChannelDefinition channelDef = new ChannelDefinitionBuilder(dp.getName(), channelType.getUID()).build();
                            channelDefinitions.add(channelDef);
                        }
                    }
                    if ((groupType = this.channelGroupTypeProvider.getInternalChannelGroupType(groupTypeUID = UidUtils.generateChannelGroupTypeUID(channel))) != null && !device.isGatewayExtras()) continue;
                    String groupLabel = String.format("%s", WordUtils.capitalizeFully((String)StringUtils.replace((String)channel.getType(), (String)"_", (String)" ")));
                    groupType = ChannelGroupTypeBuilder.instance((ChannelGroupTypeUID)groupTypeUID, (String)groupLabel).withChannelDefinitions(channelDefinitions).build();
                    this.channelGroupTypeProvider.addChannelGroupType(groupType);
                    groupTypes.add(groupType);
                }
                tt = this.createThingType(device, groupTypes);
                this.thingTypeProvider.addThingType(tt);
            }
            this.addFirmware(device);
        }
    }

    @Override
    public void validateFirmwares() {
        for (String deviceType : this.firmwaresByType.keySet()) {
            Set<String> firmwares = this.firmwaresByType.get(deviceType);
            if (firmwares.size() <= 1) continue;
            this.logger.info("Multiple firmware versions for device type '{}' found ({}). Make sure, all devices of the same type have the same firmware version, otherwise you MAY have channel and/or datapoint errors in the logfile", (Object)deviceType, (Object)StringUtils.join(firmwares, (String)", "));
        }
    }

    private void addFirmware(HmDevice device) {
        if (!(StringUtils.equals((String)device.getFirmware(), (String)"?") || "HM-RCV-50".equals(device.getType()) || "HMW-RCV-50".equals(device.getType()))) {
            Set<String> firmwares = this.firmwaresByType.get(device.getType());
            if (firmwares == null) {
                firmwares = new HashSet<String>();
                this.firmwaresByType.put(device.getType(), firmwares);
            }
            firmwares.add(device.getFirmware());
        }
    }

    private ThingType createThingType(HmDevice device, List<ChannelGroupType> groupTypes) {
        String label = MetadataUtils.getDeviceName(device);
        String description = String.format("%s (%s)", label, device.getType());
        ArrayList<String> supportedBridgeTypeUids = new ArrayList<String>();
        supportedBridgeTypeUids.add(HomematicBindingConstants.THING_TYPE_BRIDGE.toString());
        ThingTypeUID thingTypeUID = UidUtils.generateThingTypeUID(device);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("vendor", "eQ-3 AG");
        properties.put("modelId", device.getType());
        URI configDescriptionURI = this.getConfigDescriptionURI(device);
        if (this.configDescriptionProvider.getInternalConfigDescription(configDescriptionURI) == null) {
            this.generateConfigDescription(device, configDescriptionURI);
        }
        ArrayList<ChannelGroupDefinition> groupDefinitions = new ArrayList<ChannelGroupDefinition>();
        for (ChannelGroupType groupType : groupTypes) {
            String id = StringUtils.substringAfterLast((String)groupType.getUID().getId(), (String)"_");
            groupDefinitions.add(new ChannelGroupDefinition(id, groupType.getUID()));
        }
        return ThingTypeBuilder.instance((ThingTypeUID)thingTypeUID, (String)label).withSupportedBridgeTypeUIDs(supportedBridgeTypeUids).withDescription(description).withChannelGroupDefinitions(groupDefinitions).withProperties(properties).withRepresentationProperty("serialNumber").withConfigDescriptionURI(configDescriptionURI).build();
    }

    private ChannelType createChannelType(HmDatapoint dp, ChannelTypeUID channelTypeUID) {
        ChannelType channelType;
        if (dp.getName().equals("LOWBAT") || dp.getName().equals("LOW_BAT")) {
            channelType = DefaultSystemChannelTypeProvider.SYSTEM_CHANNEL_LOW_BATTERY;
        } else if (dp.getName().equals("SIGNAL_STRENGTH")) {
            channelType = DefaultSystemChannelTypeProvider.SYSTEM_CHANNEL_SIGNAL_STRENGTH;
        } else if (dp.getName().equals("BUTTON")) {
            channelType = DefaultSystemChannelTypeProvider.SYSTEM_BUTTON;
        } else {
            String itemType = MetadataUtils.getItemType(dp);
            String category = MetadataUtils.getCategory(dp, itemType);
            String label = MetadataUtils.getLabel(dp);
            String description = MetadataUtils.getDatapointDescription(dp);
            List<StateOption> options = null;
            if (dp.isEnumType()) {
                options = MetadataUtils.generateOptions(dp, new MetadataUtils.OptionsBuilder<StateOption>(){

                    @Override
                    public StateOption createOption(String value, String description) {
                        return new StateOption(value, description);
                    }
                });
            }
            StateDescription state = null;
            if (dp.isNumberType()) {
                BigDecimal min = MetadataUtils.createBigDecimal(dp.getMinValue());
                BigDecimal max = MetadataUtils.createBigDecimal(dp.getMaxValue());
                BigDecimal step = MetadataUtils.createBigDecimal(dp.getStep());
                if (step == null) {
                    step = MetadataUtils.createBigDecimal(Float.valueOf(dp.isFloatType() ? new Float(0.1).floatValue() : 1.0f));
                }
                state = new StateDescription(min, max, step, MetadataUtils.getStatePattern(dp), dp.isReadOnly(), options);
            } else {
                state = new StateDescription(null, null, null, MetadataUtils.getStatePattern(dp), dp.isReadOnly(), options);
            }
            ChannelKind channelKind = ChannelKind.STATE;
            EventDescription eventDescription = null;
            if (dp.isTrigger()) {
                itemType = null;
                channelKind = ChannelKind.TRIGGER;
                eventDescription = new EventDescription(MetadataUtils.generateOptions(dp, new MetadataUtils.OptionsBuilder<EventOption>(){

                    @Override
                    public EventOption createOption(String value, String description) {
                        return new EventOption(value, description);
                    }
                }));
            }
            channelType = new ChannelType(channelTypeUID, !MetadataUtils.isStandard(dp), itemType, channelKind, label, description, category, null, state, eventDescription, configDescriptionUriChannel);
        }
        return channelType;
    }

    private void generateConfigDescription(HmDevice device, URI configDescriptionURI) {
        ArrayList<ConfigDescriptionParameter> parms = new ArrayList<ConfigDescriptionParameter>();
        ArrayList<ConfigDescriptionParameterGroup> groups = new ArrayList<ConfigDescriptionParameterGroup>();
        for (HmChannel channel : device.getChannels()) {
            String groupName = "HMG_" + channel.getNumber();
            String groupLabel = String.valueOf(MetadataUtils.getDescription("CHANNEL_NAME")) + " " + channel.getNumber();
            groups.add(new ConfigDescriptionParameterGroup(groupName, null, Boolean.valueOf(false), groupLabel, null));
            for (HmDatapoint dp : channel.getDatapoints()) {
                if (dp.getParamsetType() != HmParamsetType.MASTER) continue;
                ConfigDescriptionParameterBuilder builder = ConfigDescriptionParameterBuilder.create((String)MetadataUtils.getParameterName(dp), (ConfigDescriptionParameter.Type)MetadataUtils.getConfigDescriptionParameterType(dp));
                builder.withLabel(MetadataUtils.getLabel(dp));
                builder.withDefault(ObjectUtils.toString((Object)dp.getDefaultValue()));
                builder.withDescription(MetadataUtils.getDatapointDescription(dp));
                if (dp.isEnumType()) {
                    builder.withLimitToOptions(Boolean.valueOf(dp.isEnumType()));
                    List<ParameterOption> options = MetadataUtils.generateOptions(dp, new MetadataUtils.OptionsBuilder<ParameterOption>(){

                        @Override
                        public ParameterOption createOption(String value, String description) {
                            return new ParameterOption(value, description);
                        }
                    });
                    builder.withOptions(options);
                }
                if (dp.isNumberType()) {
                    builder.withMinimum(MetadataUtils.createBigDecimal(dp.getMinValue()));
                    builder.withMaximum(MetadataUtils.createBigDecimal(dp.getMaxValue()));
                    builder.withStepSize(MetadataUtils.createBigDecimal(Float.valueOf(dp.isFloatType() ? new Float(0.1).floatValue() : 1.0f)));
                    builder.withUnitLabel(MetadataUtils.getUnit(dp));
                }
                builder.withGroupName(groupName);
                parms.add(builder.build());
            }
        }
        this.configDescriptionProvider.addConfigDescription(new ConfigDescription(configDescriptionURI, parms, groups));
    }

    private URI getConfigDescriptionURI(HmDevice device) {
        try {
            return new URI(String.format("%s:%s", "thing-type", UidUtils.generateThingTypeUID(device)));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.warn("Can't create configDescriptionURI for device type {}", (Object)device.getType());
            return null;
        }
    }

    public static boolean isStatusDatapoint(HmDatapoint dp) {
        return StringUtils.indexOfAny((String)dp.getName(), (String[])STATUS_DATAPOINT_NAMES) != -1;
    }

    public static boolean isIgnoredDatapoint(HmDatapoint dp) {
        return StringUtils.indexOfAny((String)dp.getName(), (String[])IGNORE_DATAPOINT_NAMES) != -1;
    }
}

