/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

public class UidUtils {
    public static ThingTypeUID generateThingTypeUID(HmDevice device) {
        if (!device.isGatewayExtras() && device.getGatewayId().equals("HOMEGEAR")) {
            return new ThingTypeUID("homematic", String.format("HG-%s", device.getType()));
        }
        return new ThingTypeUID("homematic", device.getType());
    }

    public static ChannelTypeUID generateChannelTypeUID(HmDatapoint dp) {
        return new ChannelTypeUID("homematic", String.format("%s_%s_%s", dp.getChannel().getDevice().getType(), dp.getChannel().getNumber(), dp.getName()));
    }

    public static ChannelGroupTypeUID generateChannelGroupTypeUID(HmChannel channel) {
        return new ChannelGroupTypeUID("homematic", String.format("%s_%s", channel.getDevice().getType(), channel.getNumber()));
    }

    public static ThingUID generateThingUID(HmDevice device, Bridge bridge) {
        ThingTypeUID thingTypeUID = UidUtils.generateThingTypeUID(device);
        return new ThingUID(thingTypeUID, bridge.getUID(), device.getAddress());
    }

    public static ChannelUID generateChannelUID(HmDatapoint dp, ThingUID thingUID) {
        return new ChannelUID(thingUID, String.valueOf(dp.getChannel().getNumber()), dp.getName());
    }

    public static HmDatapointInfo createHmDatapointInfo(ChannelUID channelUID) {
        return new HmDatapointInfo(channelUID.getThingUID().getId(), HmParamsetType.VALUES, NumberUtils.toInt((String)channelUID.getGroupId()), channelUID.getIdWithoutGroup());
    }

    public static String getHomematicAddress(Thing thing) {
        return thing.getUID().getId();
    }
}

