/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.blukii.handler;

import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.bluetooth.BeaconBluetoothHandler;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDeviceListener;
import org.eclipse.smarthome.binding.bluetooth.blukii.internal.data.BlukiiData;
import org.eclipse.smarthome.binding.bluetooth.blukii.internal.data.BlukiiDataDecoder;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothScanNotification;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class BlukiiHandler
extends BeaconBluetoothHandler
implements BluetoothDeviceListener {
    private final BlukiiDataDecoder decoder = new BlukiiDataDecoder();

    public BlukiiHandler(Thing thing) {
        super(thing);
    }

    public void onScanRecordReceived(BluetoothScanNotification scanNotification) {
        BlukiiData blukiiData = this.decoder.decode(scanNotification.getManufacturerData());
        if (blukiiData != null) {
            this.updateState("battery", (State)new DecimalType((long)blukiiData.battery));
            blukiiData.environment.ifPresent(environment -> {
                this.updateState("temperature", (State)new QuantityType((Number)environment.temperature, SIUnits.CELSIUS));
                this.updateState("humidity", (State)new QuantityType((Number)environment.humidity, SmartHomeUnits.PERCENT));
                this.updateState("pressure", (State)new QuantityType((Number)environment.pressure, MetricPrefix.HECTO((Unit)SIUnits.PASCAL)));
                this.updateState("luminance", (State)new QuantityType((Number)environment.luminance, SmartHomeUnits.LUX));
            });
            blukiiData.accelerometer.ifPresent(accelerometer -> {
                this.updateState("tiltx", (State)new QuantityType((Number)accelerometer.tiltX, SmartHomeUnits.DEGREE_ANGLE));
                this.updateState("tilty", (State)new QuantityType((Number)accelerometer.tiltY, SmartHomeUnits.DEGREE_ANGLE));
                this.updateState("tiltz", (State)new QuantityType((Number)accelerometer.tiltZ, SmartHomeUnits.DEGREE_ANGLE));
            });
            blukiiData.magnetometer.ifPresent(magnetometer -> {});
        }
        super.onScanRecordReceived(scanNotification);
    }
}

