/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.blukii.internal.data;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.blukii.internal.data.Accelerometer;
import org.eclipse.smarthome.binding.bluetooth.blukii.internal.data.BlukiiData;
import org.eclipse.smarthome.binding.bluetooth.blukii.internal.data.Environment;
import org.eclipse.smarthome.binding.bluetooth.blukii.internal.data.Magnetometer;
import org.eclipse.smarthome.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class BlukiiDataDecoder {
    private final Logger logger = LoggerFactory.getLogger(BlukiiDataDecoder.class);

    public @Nullable BlukiiData decode(byte[] data) {
        Optional<Accelerometer> accelerometer;
        Optional<Object> environment;
        Optional<Magnetometer> magnetometer;
        if (data[0] != 79) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Decode Blukii data: {}", (Object)HexUtils.bytesToHex((byte[])data, (CharSequence)" "));
        }
        int battery = data[12] & 0x7F;
        if ((data[14] & 0x30) == 48) {
            magnetometer = Optional.of(BlukiiDataDecoder.processMagnetometerData(data));
            environment = Optional.empty();
            accelerometer = Optional.empty();
        } else if ((data[14] & 0x10) == 16) {
            magnetometer = Optional.empty();
            environment = Optional.of(BlukiiDataDecoder.processEnvironmentData(data));
            accelerometer = Optional.empty();
        } else if ((data[14] & 0x20) == 32) {
            magnetometer = Optional.empty();
            environment = Optional.empty();
            accelerometer = Optional.of(BlukiiDataDecoder.processAccelerometerData(data));
        } else {
            magnetometer = Optional.empty();
            environment = Optional.empty();
            accelerometer = Optional.empty();
        }
        return new BlukiiData(battery, magnetometer, environment, accelerometer);
    }

    private static Environment processEnvironmentData(byte[] data) {
        double pressure = BlukiiDataDecoder.doubleByteToInt(data[15], data[16]) / 10;
        int luminance = BlukiiDataDecoder.doubleByteToInt(data[17], data[18]);
        int humidity = data[19] & 0xFF;
        double temperature = (double)(data[20] << 8 | data[21] & 0xFF) / 256.0;
        return new Environment(pressure, luminance, humidity, temperature);
    }

    private static Accelerometer processAccelerometerData(byte[] data) {
        int range = data[15] & 0xFF;
        int x = (short)BlukiiDataDecoder.doubleByteToInt(data[16], data[17]) * (range / 2);
        int y = (short)BlukiiDataDecoder.doubleByteToInt(data[18], data[19]) * (range / 2);
        int z = (short)BlukiiDataDecoder.doubleByteToInt(data[20], data[21]) * (range / 2);
        double tiltX = 180.0 * Math.acos((double)x / Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0))) / Math.PI;
        double tiltY = 180.0 * Math.acos((double)y / Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0))) / Math.PI;
        double tiltZ = 180.0 * Math.acos((double)z / Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0))) / Math.PI;
        return new Accelerometer(tiltX, tiltY, tiltZ);
    }

    private static Magnetometer processMagnetometerData(byte[] data) {
        short x = (short)BlukiiDataDecoder.doubleByteToInt(data[16], data[17]);
        short y = (short)BlukiiDataDecoder.doubleByteToInt(data[18], data[19]);
        short z = (short)BlukiiDataDecoder.doubleByteToInt(data[20], data[21]);
        return new Magnetometer(x, y, z);
    }

    private static int doubleByteToInt(byte b1, byte b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        return i1 * 256 + i2;
    }
}

