/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.automation.core.dto.ConditionDTOMapper;
import org.eclipse.smarthome.automation.core.dto.ModuleTypeDTOMapper;
import org.eclipse.smarthome.automation.dto.CompositeConditionTypeDTO;
import org.eclipse.smarthome.automation.dto.ConditionTypeDTO;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;

public class ConditionTypeDTOMapper
extends ModuleTypeDTOMapper {
    public static ConditionTypeDTO map(ConditionType conditionType) {
        return ConditionTypeDTOMapper.map(conditionType, new ConditionTypeDTO());
    }

    public static CompositeConditionTypeDTO map(CompositeConditionType conditionType) {
        CompositeConditionTypeDTO conditionTypeDto = ConditionTypeDTOMapper.map((ConditionType)conditionType, new CompositeConditionTypeDTO());
        conditionTypeDto.children = ConditionDTOMapper.map(conditionType.getChildren());
        return conditionTypeDto;
    }

    public static ConditionType map(CompositeConditionTypeDTO conditionTypeDto) {
        if (conditionTypeDto.children == null || conditionTypeDto.children.isEmpty()) {
            return new ConditionType(conditionTypeDto.uid, ConfigDescriptionDTOMapper.map((List)conditionTypeDto.configDescriptions), conditionTypeDto.label, conditionTypeDto.description, conditionTypeDto.tags, conditionTypeDto.visibility, conditionTypeDto.inputs);
        }
        return new CompositeConditionType(conditionTypeDto.uid, ConfigDescriptionDTOMapper.map((List)conditionTypeDto.configDescriptions), conditionTypeDto.label, conditionTypeDto.description, conditionTypeDto.tags, conditionTypeDto.visibility, conditionTypeDto.inputs, ConditionDTOMapper.mapDto(conditionTypeDto.children));
    }

    public static List<ConditionTypeDTO> map(Collection<ConditionType> types) {
        if (types == null) {
            return null;
        }
        ArrayList<ConditionTypeDTO> dtos = new ArrayList<ConditionTypeDTO>(types.size());
        for (ConditionType type : types) {
            if (type instanceof CompositeConditionType) {
                dtos.add((ConditionTypeDTO)ConditionTypeDTOMapper.map((CompositeConditionType)type));
                continue;
            }
            dtos.add(ConditionTypeDTOMapper.map(type));
        }
        return dtos;
    }

    private static <T extends ConditionTypeDTO> T map(ConditionType conditionType, T conditionTypeDto) {
        ConditionTypeDTOMapper.fillProperties((ModuleType)conditionType, conditionTypeDto);
        conditionTypeDto.inputs = conditionType.getInputs();
        return conditionTypeDto;
    }
}

