/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.Configuration;

@NonNullByDefault
public class RuleImpl
implements Rule {
    @NonNullByDefault(value={})
    protected List<Trigger> triggers;
    @NonNullByDefault(value={})
    protected List<Condition> conditions;
    @NonNullByDefault(value={})
    protected List<Action> actions;
    @NonNullByDefault(value={})
    protected Configuration configuration;
    @NonNullByDefault(value={})
    protected List<ConfigDescriptionParameter> configDescriptions;
    protected @Nullable String templateUID;
    @NonNullByDefault(value={})
    protected String uid;
    protected @Nullable String name;
    @NonNullByDefault(value={})
    protected Set<String> tags;
    @NonNullByDefault(value={})
    protected Visibility visibility;
    protected @Nullable String description;

    public RuleImpl(@Nullable String uid) {
        this(uid, null, null, null, null, null, null, null, null, null, null);
    }

    public RuleImpl(@Nullable String uid, @Nullable String name, @Nullable String description, @Nullable Set<String> tags, @Nullable List<Trigger> triggers, @Nullable List<Condition> conditions, @Nullable List<Action> actions, @Nullable List<ConfigDescriptionParameter> configDescriptions, @Nullable Configuration configuration, @Nullable String templateUID, @Nullable Visibility visibility) {
        this.uid = uid == null ? UUID.randomUUID().toString() : uid;
        this.name = name;
        this.description = description;
        this.tags = tags == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(tags));
        this.triggers = triggers == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Trigger>(triggers));
        this.conditions = conditions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Condition>(conditions));
        this.actions = actions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Action>(actions));
        this.configDescriptions = configDescriptions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ConfigDescriptionParameter>(configDescriptions));
        this.configuration = configuration == null ? new Configuration() : new Configuration(configuration.getProperties());
        this.templateUID = templateUID;
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
    }

    public String getUID() {
        return this.uid;
    }

    public @Nullable String getTemplateUID() {
        return this.templateUID;
    }

    public void setTemplateUID(@Nullable String templateUID) {
        this.templateUID = templateUID;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String ruleName) {
        this.name = ruleName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nullable Set<String> ruleTags) {
        this.tags = ruleTags == null ? Collections.emptySet() : Collections.unmodifiableSet(ruleTags);
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String ruleDescription) {
        this.description = ruleDescription;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(@Nullable Visibility visibility) {
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nullable Configuration ruleConfiguration) {
        this.configuration = ruleConfiguration == null ? new Configuration() : ruleConfiguration;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescriptions() {
        return this.configDescriptions;
    }

    public void setConfigurationDescriptions(@Nullable List<ConfigDescriptionParameter> configDescriptions) {
        this.configDescriptions = configDescriptions == null ? Collections.emptyList() : Collections.unmodifiableList(configDescriptions);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<Condition> conditions) {
        this.conditions = conditions == null ? Collections.emptyList() : Collections.unmodifiableList(conditions);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setActions(@Nullable List<Action> actions) {
        this.actions = actions == null ? Collections.emptyList() : Collections.unmodifiableList(actions);
    }

    public void setTriggers(@Nullable List<Trigger> triggers) {
        this.triggers = triggers == null ? Collections.emptyList() : Collections.unmodifiableList(triggers);
    }

    public List<Module> getModules() {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.addAll(this.triggers);
        modules.addAll(this.conditions);
        modules.addAll(this.actions);
        List<Module> result = Collections.unmodifiableList(modules);
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.uid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleImpl)) {
            return false;
        }
        RuleImpl other = (RuleImpl)obj;
        return this.uid.equals(other.uid);
    }
}

