/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.ModuleHandlerCallback;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.core.util.ReferenceResolver;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.Output;

public class CompositeTriggerHandler
extends AbstractCompositeModuleHandler<Trigger, CompositeTriggerType, TriggerHandler>
implements TriggerHandler,
TriggerHandlerCallback {
    private TriggerHandlerCallback callback;

    public CompositeTriggerHandler(Trigger trigger, CompositeTriggerType mt, LinkedHashMap<Trigger, TriggerHandler> mapModuleToHandler, String ruleUID) {
        super(trigger, mt, mapModuleToHandler);
    }

    public void triggered(Trigger trigger, Map<String, ?> context) {
        if (this.callback != null) {
            List outputs = ((CompositeTriggerType)this.moduleType).getOutputs();
            HashMap<String, Object> result = new HashMap<String, Object>(11);
            for (Output output : outputs) {
                String refs = output.getReference();
                if (refs == null) continue;
                StringTokenizer st = new StringTokenizer(refs, ",");
                while (st.hasMoreTokens()) {
                    String ref = st.nextToken().trim();
                    int i = ref.indexOf(46);
                    if (i != -1) {
                        String childModuleId = ref.substring(0, i);
                        if (trigger.getId().equals(childModuleId)) {
                            ref = ref.substring(i + 1);
                        }
                    }
                    Object value = null;
                    int idx = ReferenceResolver.getNextRefToken(ref, 1);
                    if (idx < ref.length()) {
                        String outputId = ref.substring(0, idx);
                        value = ReferenceResolver.resolveComplexDataReference(context.get(outputId), ref.substring(idx + 1));
                    } else {
                        value = context.get(ref);
                    }
                    if (value == null) continue;
                    result.put(output.getName(), value);
                }
            }
            this.callback.triggered((Trigger)this.module, result);
        }
    }

    @Override
    public void setCallback(@Nullable ModuleHandlerCallback callback) {
        this.callback = (TriggerHandlerCallback)callback;
        if (callback instanceof TriggerHandlerCallback) {
            List<Trigger> children = this.getChildren();
            for (Trigger child : children) {
                TriggerHandler handler = (TriggerHandler)this.moduleHandlerMap.get(child);
                handler.setCallback((ModuleHandlerCallback)this);
            }
        }
    }

    @Override
    public void dispose() {
        this.setCallback(null);
        super.dispose();
    }

    @Override
    protected List<Trigger> getChildren() {
        return ((CompositeTriggerType)this.moduleType).getChildren();
    }

    public Boolean isEnabled(String ruleUID) {
        return this.callback.isEnabled(ruleUID);
    }

    public void setEnabled(String uid, boolean isEnabled) {
        this.callback.setEnabled(uid, isEnabled);
    }

    public RuleStatusInfo getStatusInfo(String ruleUID) {
        return this.callback.getStatusInfo(ruleUID);
    }

    public RuleStatus getStatus(String ruleUID) {
        return this.callback.getStatus(ruleUID);
    }

    public void runNow(String uid) {
        this.callback.runNow(uid);
    }

    public void runNow(String uid, boolean considerConditions, Map<String, Object> context) {
        this.callback.runNow(uid, considerConditions, context);
    }
}

