/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.ruleengine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusDetail;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedAction;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedCondition;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedModule;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedTrigger;
import org.eclipse.smarthome.automation.handler.ModuleHandler;

@NonNullByDefault
public class WrappedRule {
    private final Rule rule;
    private RuleStatusInfo statusInfo = new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.NONE);
    private final List<WrappedModule<Module, ModuleHandler>> modules;
    private final List<WrappedAction> actions;
    private final List<WrappedCondition> conditions;
    private final List<WrappedTrigger> triggers;

    private static <T extends WrappedModule, U extends Module> List<T> map(List<U> in, Function<U, T> factory, Collection<WrappedModule<Module, ModuleHandler>> coll) {
        return Collections.unmodifiableList(in.stream().map(module -> {
            WrappedModule impl = (WrappedModule)factory.apply(module);
            coll.add(impl);
            return impl;
        }).collect(Collectors.toList()));
    }

    public WrappedRule(Rule rule) {
        this.rule = rule;
        LinkedList<WrappedModule<Module, ModuleHandler>> modules = new LinkedList<WrappedModule<Module, ModuleHandler>>();
        this.actions = WrappedRule.map(rule.getActions(), WrappedAction::new, modules);
        this.conditions = WrappedRule.map(rule.getConditions(), WrappedCondition::new, modules);
        this.triggers = WrappedRule.map(rule.getTriggers(), WrappedTrigger::new, modules);
        this.modules = Collections.unmodifiableList(modules);
    }

    public final String getUID() {
        return this.rule.getUID();
    }

    public final Rule unwrap() {
        return this.rule;
    }

    public RuleStatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public void setStatusInfo(RuleStatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    public List<WrappedAction> getActions() {
        return this.actions;
    }

    public List<WrappedCondition> getConditions() {
        return this.conditions;
    }

    public List<WrappedTrigger> getTriggers() {
        return this.triggers;
    }

    public List<WrappedModule<Module, ModuleHandler>> getModules() {
        return this.modules;
    }
}

