/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.core.internal.ActionImpl;
import org.eclipse.smarthome.automation.core.util.ModuleBuilder;

@NonNullByDefault
public class ActionBuilder
extends ModuleBuilder<ActionBuilder, Action> {
    private @Nullable Map<String, String> inputs;

    protected ActionBuilder() {
    }

    protected ActionBuilder(Action action) {
        super(action);
        this.inputs = action.getInputs();
    }

    public static ActionBuilder create() {
        return new ActionBuilder();
    }

    public static ActionBuilder create(Action action) {
        return new ActionBuilder(action);
    }

    public ActionBuilder withInputs(@Nullable Map<String, String> inputs) {
        this.inputs = inputs != null ? Collections.unmodifiableMap(new HashMap<String, String>(inputs)) : null;
        return this;
    }

    @Override
    public Action build() {
        return new ActionImpl(this.getId(), this.getTypeUID(), this.configuration, this.label, this.description, this.inputs);
    }
}

