/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class Stream2JSONInputStream
extends InputStream {
    private final Iterator<String> iterator;
    private InputStream jsonElementStream;
    private boolean firstIteratorElement;
    private Gson gson = new GsonBuilder().create();

    public Stream2JSONInputStream(Stream<?> source) {
        if (source == null) {
            throw new IllegalArgumentException("The source must not be null!");
        }
        this.iterator = source.map(e -> this.gson.toJson(e)).iterator();
        this.jsonElementStream = IOUtils.toInputStream((String)"");
        this.firstIteratorElement = true;
    }

    @Override
    public int read() throws IOException {
        int result = this.jsonElementStream.read();
        if (result == -1) {
            if (this.finished()) {
                return -1;
            }
            this.fillBuffer();
            result = this.jsonElementStream.read();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.jsonElementStream.close();
    }

    private void fillBuffer() {
        String prefix;
        if (this.firstIteratorElement) {
            prefix = "[";
            this.firstIteratorElement = false;
        } else {
            prefix = ",";
        }
        String entity = this.iterator.hasNext() ? this.iterator.next() : "";
        String postfix = "";
        if (!this.iterator.hasNext()) {
            postfix = "]";
        }
        IOUtils.closeQuietly((InputStream)this.jsonElementStream);
        try {
            this.jsonElementStream = IOUtils.toInputStream((String)(String.valueOf(prefix) + entity + postfix), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException iOException) {}
    }

    private boolean finished() {
        return !this.firstIteratorElement && !this.iterator.hasNext();
    }
}

