/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.discovery;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;

@NonNullByDefault
public class TopicSubscribe
implements MqttMessageSubscriber {
    final MqttBrokerConnection connection;
    final ThingUID thing;
    final String topic;
    final MQTTTopicDiscoveryParticipant topicDiscoveredListener;

    public TopicSubscribe(MqttBrokerConnection connection, String topic, MQTTTopicDiscoveryParticipant topicDiscoveredListener, ThingUID thing) {
        this.connection = connection;
        this.thing = thing;
        this.topic = topic;
        this.topicDiscoveredListener = topicDiscoveredListener;
    }

    public void processMessage(String topic, byte[] payload) {
        this.topicDiscoveredListener.receivedMessage(this.thing, this.connection, topic, payload);
    }

    public CompletableFuture<Boolean> start() {
        return this.connection.subscribe(this.topic, (MqttMessageSubscriber)this);
    }

    public CompletableFuture<Boolean> stop() {
        return this.connection.unsubscribe(this.topic, (MqttMessageSubscriber)this);
    }
}

