/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Colorpicker;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.eclipse.smarthome.ui.classic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class ColorpickerRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Colorpicker;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Colorpicker cp = (Colorpicker)w;
        String snippetName = "colorpicker";
        String snippet = this.getSnippet(snippetName);
        String frequency = cp.getFrequency() == 0 ? "200" : Integer.toString(cp.getFrequency());
        State state = this.itemUIRegistry.getState((Widget)cp);
        String hexValue = "#ffffff";
        if (state instanceof HSBType) {
            HSBType hsbState = (HSBType)state;
            hexValue = "#" + Integer.toHexString(hsbState.getRGB()).substring(2);
        }
        String label = this.getLabel((Widget)cp);
        String purelabel = this.itemUIRegistry.getLabel(w);
        purelabel = purelabel.replaceAll("\\\"", "\\\\'");
        snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)this.itemUIRegistry.getWidgetId((Widget)cp));
        snippet = StringUtils.replace((String)snippet, (String)"%category%", (String)this.getCategory((Widget)cp));
        snippet = StringUtils.replace((String)snippet, (String)"%item%", (String)w.getItem());
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)label);
        snippet = StringUtils.replace((String)snippet, (String)"%format%", (String)this.getFormat());
        snippet = StringUtils.replace((String)snippet, (String)"%purelabel%", (String)purelabel);
        snippet = StringUtils.replace((String)snippet, (String)"%state%", (String)hexValue);
        snippet = StringUtils.replace((String)snippet, (String)"%frequency%", (String)frequency);
        snippet = StringUtils.replace((String)snippet, (String)"%servletname%", (String)"app");
        String style = "";
        String color = this.itemUIRegistry.getLabelColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)style);
        style = "";
        color = this.itemUIRegistry.getValueColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%valuestyle%", (String)style);
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

