/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.eclipse.smarthome.ui.classic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class VideoRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Video;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Video videoWidget = (Video)w;
        String snippet = null;
        String widgetId = this.itemUIRegistry.getWidgetId(w);
        String sitemap = w.eResource().getURI().path();
        if (videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("mjpeg")) {
            snippet = this.getSnippet("image");
            snippet = StringUtils.replace((String)snippet, (String)"%setrefresh%", (String)"");
            snippet = StringUtils.replace((String)snippet, (String)"%refresh%", (String)"");
        } else {
            snippet = this.getSnippet("video");
        }
        String url = "../proxy?sitemap=" + sitemap + "&widgetId=" + widgetId;
        String mediaType = "";
        if (videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("hls")) {
            State state = this.itemUIRegistry.getState(w);
            url = state instanceof StringType ? state.toString() : videoWidget.getUrl();
            mediaType = "type=\"application/vnd.apple.mpegurl\"";
        }
        snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
        snippet = StringUtils.replace((String)snippet, (String)"%media_type%", (String)mediaType);
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

