/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileAction
extends Action {
    public static final String ID = "org.eclipse.smarthome.designer.ui.OpenFileAction";
    private Viewer viewer;

    public OpenFileAction(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IFile) {
            this.openFile((IFile)obj);
        }
    }

    void openFile(IFile file) {
        IEditorDescriptor editor;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FileEditorInput editorInput = null;
        if (editorInput == null) {
            editorInput = new FileEditorInput(file);
        }
        String editorId = (editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName())) == null ? "org.eclipse.ui.DefaultTextEditor" : editor.getId();
        try {
            activePage.openEditor((IEditorInput)editorInput, editorId);
        }
        catch (PartInitException e1) {
            e1.printStackTrace();
        }
    }
}

