/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;

public class InvariantChecker {
    private boolean exceptionSeen;

    public void checkInvariant(INode node) throws InconsistentNodeModelException {
        try {
            this.doCheckInvariant(node.getRootNode());
        }
        catch (ClassCastException e) {
            throw new InconsistentNodeModelException("node has no root node", e);
        }
        catch (NullPointerException e) {
            throw new InconsistentNodeModelException("node's pointer is null", e);
        }
    }

    protected void doCheckInvariant(ICompositeNode rootNode) {
        int length = this.doCheckCompositeNodeAndReturnTotalLength(rootNode, 0);
        if (length != rootNode.getTotalLength()) {
            throw new InconsistentNodeModelException("node's computed length differs from actual total length");
        }
    }

    protected int doCheckCompositeNodeAndReturnTotalLength(ICompositeNode node, int startsAt) {
        if (node.getTotalOffset() != startsAt) {
            throw new InconsistentNodeModelException("node with unexpected offset");
        }
        int length = 0;
        for (INode iNode : ((CompositeNode)node).basicGetChildren()) {
            length += this.doCheckChildNodeAndReturnTotalLength(iNode, node, startsAt + length);
        }
        if (length != node.getTotalLength()) {
            throw new InconsistentNodeModelException("node's computed length differs from actual total length");
        }
        return length;
    }

    protected int doCheckChildNodeAndReturnTotalLength(INode child, ICompositeNode parent, int startsAt) {
        this.exceptionSeen |= child.getSyntaxErrorMessage() != null;
        if (((AbstractNode)child).basicGetNextSibling().basicGetPreviousSibling() != child) {
            throw new InconsistentNodeModelException("child.next.previous != child");
        }
        if (((AbstractNode)child).basicGetPreviousSibling().basicGetNextSibling() != child) {
            throw new InconsistentNodeModelException("child.previous.next != child");
        }
        if (((AbstractNode)child).basicGetPreviousSibling().basicGetParent() != ((AbstractNode)child).basicGetParent()) {
            throw new InconsistentNodeModelException("child.previous.parent != child.parent");
        }
        if (((AbstractNode)child).basicGetNextSibling().basicGetParent() != ((AbstractNode)child).basicGetParent()) {
            throw new InconsistentNodeModelException("child.next.parent != child.parent");
        }
        if (((AbstractNode)child).basicGetParent() != parent) {
            throw new InconsistentNodeModelException("node does not point to its parent");
        }
        if (child instanceof ILeafNode) {
            if (child.getGrammarElement() == null && !this.exceptionSeen) {
                throw new InconsistentNodeModelException("leaf node without grammar element");
            }
            return this.doCheckLeafNodeAndReturnLength((ILeafNode)child, startsAt);
        }
        if (child.getGrammarElement() == null) {
            throw new InconsistentNodeModelException("node without grammar element");
        }
        return this.doCheckCompositeNodeAndReturnTotalLength((ICompositeNode)child, startsAt);
    }

    protected int doCheckLeafNodeAndReturnLength(ILeafNode leafNode, int startsAt) {
        if (leafNode.getTotalOffset() != startsAt) {
            throw new InconsistentNodeModelException("node with unexpected offset");
        }
        return leafNode.getTotalLength();
    }

    public static class InconsistentNodeModelException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InconsistentNodeModelException(String message, Throwable cause) {
            super(message, cause);
        }

        public InconsistentNodeModelException(String message) {
            super(message);
        }
    }
}

