/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.registry;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProvider<E>
implements Provider<E> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractProvider.class);
    protected List<ProviderChangeListener<E>> listeners = new CopyOnWriteArrayList<ProviderChangeListener<E>>();

    @Override
    public void addProviderChangeListener(ProviderChangeListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProviderChangeListener(ProviderChangeListener<E> listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(E oldElement, E element, EventType eventType) {
        for (ProviderChangeListener<E> listener : this.listeners) {
            try {
                switch (eventType) {
                    case ADDED: {
                        listener.added(this, element);
                        break;
                    }
                    case REMOVED: {
                        listener.removed(this, element);
                        break;
                    }
                    case UPDATED: {
                        listener.updated(this, oldElement, element);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Could not inform the listener '" + listener + "' about the '" + eventType.name() + "' event!: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void notifyListeners(E element, EventType eventType) {
        this.notifyListeners(null, element, eventType);
    }

    protected void notifyListenersAboutAddedElement(E element) {
        this.notifyListeners(element, EventType.ADDED);
    }

    protected void notifyListenersAboutRemovedElement(E element) {
        this.notifyListeners(element, EventType.REMOVED);
    }

    protected void notifyListenersAboutUpdatedElement(E oldElement, E element) {
        this.notifyListeners(oldElement, element, EventType.UPDATED);
    }

    private static enum EventType {
        ADDED,
        REMOVED,
        UPDATED;

    }
}

