/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public abstract class GenericItem
implements Item {
    protected EventPublisher eventPublisher;
    protected Set<StateChangeListener> listeners = new CopyOnWriteArraySet(Collections.newSetFromMap(new WeakHashMap()));
    protected List<String> groupNames = new ArrayList<String>();
    protected final String name;
    protected final String type;
    protected State state = UnDefType.NULL;

    public GenericItem(String type, String name) {
        this.name = name;
        this.type = type;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        if (typeClass != null && typeClass.isInstance(this.state)) {
            return this.state;
        }
        return null;
    }

    public void initialize() {
    }

    public void dispose() {
        this.eventPublisher = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getGroupNames() {
        return ImmutableList.copyOf(this.groupNames);
    }

    public void addGroupName(String groupItemName) {
        if (!this.groupNames.contains(groupItemName)) {
            this.groupNames.add(groupItemName);
        }
    }

    public void removeGroupName(String groupItemName) {
        this.groupNames.remove(groupItemName);
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void internalSend(Command command) {
        if (this.eventPublisher != null) {
            this.eventPublisher.sendCommand(this.getName(), command);
        }
    }

    public void setState(State state) {
        State oldState = this.state;
        this.state = state;
        this.notifyListeners(oldState, state);
    }

    public void send(RefreshType command) {
        this.internalSend(command);
    }

    private void notifyListeners(State oldState, State newState) {
        CopyOnWriteArraySet<StateChangeListener> clonedListeners = null;
        clonedListeners = new CopyOnWriteArraySet<StateChangeListener>(this.listeners);
        for (StateChangeListener listener : clonedListeners) {
            listener.stateUpdated(this, newState);
        }
        if (!oldState.equals(newState)) {
            for (StateChangeListener listener : clonedListeners) {
                listener.stateChanged(this, oldState, newState);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + "Type=" + this.getClass().getSimpleName() + ", " + "State=" + this.getState() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(StateChangeListener listener) {
        Set<StateChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(StateChangeListener listener) {
        Set<StateChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericItem other = (GenericItem)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

