/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.CleanUpAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.ui.IWorkbenchSite;

public class AllCleanUpsAction
extends CleanUpAction {
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;

    public AllCleanUpsAction(IWorkbenchSite site) {
        super(site);
        this.setToolTipText(ActionMessages.CleanUpAction_tooltip);
        this.setDescription(ActionMessages.CleanUpAction_description);
        this.installPreferenceListener();
        this.updateActionLabel();
    }

    public AllCleanUpsAction(JavaEditor editor) {
        super(editor);
        this.setToolTipText(ActionMessages.CleanUpAction_tooltip);
        this.setDescription(ActionMessages.CleanUpAction_description);
        this.installPreferenceListener();
        this.updateActionLabel();
    }

    protected ICleanUp[] getCleanUps(ICompilationUnit[] units) {
        return JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps();
    }

    protected String getActionName() {
        return ActionMessages.CleanUpAction_actionName;
    }

    protected void performRefactoring(ICompilationUnit[] cus, ICleanUp[] cleanUps) throws InvocationTargetException {
        RefactoringExecutionStarter.startCleanupRefactoring(cus, cleanUps, !this.showWizard(), this.getShell(), this.showWizard(), this.getActionName());
    }

    private boolean showWizard() {
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ui");
        if (instanceNode.get("cleanup.showwizard", null) != null) {
            return instanceNode.getBoolean("cleanup.showwizard", true);
        }
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ui");
        return defaultNode.getBoolean("cleanup.showwizard", true);
    }

    private void updateActionLabel() {
        if (this.showWizard()) {
            this.setText(ActionMessages.CleanUpAction_labelWizard);
        } else {
            this.setText(ActionMessages.CleanUpAction_label);
        }
    }

    private void installPreferenceListener() {
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("cleanup.showwizard")) {
                    AllCleanUpsAction.this.updateActionLabel();
                }
            }
        };
        InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ui").addPreferenceChangeListener(this.fPreferenceChangeListener);
    }

    public void dispose() {
        if (this.fPreferenceChangeListener != null) {
            InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ui").removePreferenceChangeListener(this.fPreferenceChangeListener);
            this.fPreferenceChangeListener = null;
        }
    }
}

