/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.UID;

public class ThingUID
extends UID {
    public ThingUID(ThingTypeUID thingTypeUID, String id) {
        super(thingTypeUID.getBindingId(), thingTypeUID.getId(), id);
    }

    public ThingUID(ThingTypeUID thingTypeUID, ThingUID bridgeUID, String id) {
        super(ThingUID.getArray(thingTypeUID.getBindingId(), thingTypeUID.getId(), id, bridgeUID.getBridgeIds(), bridgeUID.getId()));
    }

    public ThingUID(ThingTypeUID thingTypeUID, String id, String ... bridgeIds) {
        super(ThingUID.getArray(thingTypeUID.getBindingId(), thingTypeUID.getId(), id, bridgeIds));
    }

    private static String[] getArray(String bindingId, String thingTypeId, String id, String ... bridgeIds) {
        if (bridgeIds == null || bridgeIds.length == 0) {
            return new String[]{bindingId, thingTypeId, id};
        }
        String[] result = new String[3 + bridgeIds.length];
        result[0] = bindingId;
        result[1] = thingTypeId;
        int i = 0;
        while (i < bridgeIds.length) {
            result[i + 2] = bridgeIds[i];
            ++i;
        }
        result[result.length - 1] = id;
        return result;
    }

    private static String[] getArray(String bindingId, String thingTypeId, String id, List<String> bridgeIds, String bridgeId) {
        ArrayList<String> allBridgeIds = new ArrayList<String>(bridgeIds);
        allBridgeIds.add(bridgeId);
        return ThingUID.getArray(bindingId, thingTypeId, id, allBridgeIds.toArray(new String[0]));
    }

    public ThingUID(String bindingId, String thingTypeId, String id) {
        super(bindingId, thingTypeId, id);
    }

    public ThingUID(String thingUID) {
        super(thingUID);
    }

    public ThingUID(String ... segments) {
        super(segments);
    }

    public String getThingTypeId() {
        return this.getSegment(1);
    }

    public ThingTypeUID getThingTypeUID() {
        return new ThingTypeUID(this.getSegment(0), this.getSegment(1));
    }

    public List<String> getBridgeIds() {
        ArrayList<String> bridgeIds = new ArrayList<String>();
        String[] segments = this.getSegments();
        int i = 2;
        while (i < segments.length - 1) {
            bridgeIds.add(segments[i]);
            ++i;
        }
        return bridgeIds;
    }

    public String getId() {
        String[] segments = this.getSegments();
        return segments[segments.length - 1];
    }

    @Override
    protected int getMinimalNumberOfSegments() {
        return 3;
    }
}

