/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.internal.ThingListener;
import org.eclipse.smarthome.core.types.State;

public class ThingImpl
implements Thing {
    private ThingUID bridgeUID;
    private List<Channel> channels;
    private Configuration configuration = new Configuration();
    private ThingUID uid;
    private volatile transient ThingStatus status = ThingStatus.OFFLINE;
    private volatile transient ThingHandler thingHandler;
    private volatile transient List<ThingListener> thingListeners = new CopyOnWriteArrayList<ThingListener>();
    private String name;
    private ThingTypeUID thingTypeUID;

    ThingImpl() {
    }

    public ThingImpl(ThingTypeUID thingTypeUID, String thingId) throws IllegalArgumentException {
        this.uid = new ThingUID(thingTypeUID.getBindingId(), thingTypeUID.getId(), thingId);
        this.thingTypeUID = thingTypeUID;
        this.channels = new ArrayList<Channel>(0);
    }

    public ThingImpl(ThingUID thingUID) throws IllegalArgumentException {
        this.uid = thingUID;
        this.thingTypeUID = new ThingTypeUID(thingUID.getBindingId(), thingUID.getThingTypeId());
        this.channels = new ArrayList<Channel>(0);
    }

    public void addThingListener(ThingListener thingListener) {
        this.thingListeners.add(thingListener);
    }

    @Override
    public void channelUpdated(ChannelUID channelUID, State state) {
        for (ThingListener thingListener : this.thingListeners) {
            thingListener.channelUpdated(channelUID, state);
        }
    }

    @Override
    public ThingUID getBridgeUID() {
        return this.bridgeUID;
    }

    @Override
    public List<Channel> getChannels() {
        return ImmutableList.copyOf(this.channels);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ThingHandler getHandler() {
        return this.thingHandler;
    }

    @Override
    public ThingUID getUID() {
        return this.uid;
    }

    @Override
    public ThingStatus getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void removeThingListener(ThingListener thingListener) {
        this.thingListeners.remove(thingListener);
    }

    @Override
    public void setBridgeUID(ThingUID bridgeUID) {
        this.bridgeUID = bridgeUID;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration == null ? new Configuration() : configuration;
    }

    @Override
    public void setHandler(ThingHandler thingHandler) {
        this.thingHandler = thingHandler;
    }

    public void setId(ThingUID id) {
        this.uid = id;
    }

    @Override
    public void setStatus(ThingStatus status) {
        this.status = status;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ThingTypeUID getThingTypeUID() {
        return this.thingTypeUID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingImpl other = (ThingImpl)obj;
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }
}

