/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.internal.BridgeImpl;
import org.eclipse.smarthome.core.thing.internal.ThingTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingRegistryImpl
extends AbstractRegistry<Thing>
implements ThingRegistry {
    private Logger logger = LoggerFactory.getLogger((String)ThingRegistryImpl.class.getName());
    private List<ThingTracker> thingTrackers = new CopyOnWriteArrayList<ThingTracker>();

    public void addThingTracker(ThingTracker thingTracker) {
        this.notifyTrackerAboutAllThingsAdded(thingTracker);
        this.thingTrackers.add(thingTracker);
    }

    @Override
    public Thing getByUID(ThingUID uid) {
        for (Thing thing : this.getAll()) {
            if (!thing.getUID().equals(uid)) continue;
            return thing;
        }
        return null;
    }

    public void removeThingTracker(ThingTracker thingTracker) {
        this.notifyTrackerAboutAllThingsRemoved(thingTracker);
        this.thingTrackers.remove(thingTracker);
    }

    protected void notifyListenersAboutAddedElement(Thing element) {
        super.notifyListenersAboutAddedElement((Object)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_ADDED);
    }

    protected void notifyListenersAboutRemovedElement(Thing element) {
        super.notifyListenersAboutRemovedElement((Object)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_REMOVED);
    }

    protected void notifyListenersAboutUpdatedElement(Thing oldElement, Thing element) {
        super.notifyListenersAboutUpdatedElement((Object)oldElement, (Object)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_UPDATED);
    }

    protected void onAddElement(Thing thing) throws IllegalArgumentException {
        this.addThingToBridge(thing);
        if (thing instanceof Bridge) {
            this.addThingsToBridge((Bridge)thing);
        }
    }

    protected void onRemoveElement(Thing thing) {
        Thing bridge;
        ThingUID bridgeUID = thing.getBridgeUID();
        if (bridgeUID != null && (bridge = this.getByUID(bridgeUID)) instanceof BridgeImpl) {
            ((BridgeImpl)bridge).removeThing(thing);
        }
    }

    protected void onUpdateElement(Thing oldThing, Thing thing) {
        this.onRemoveElement(thing);
        this.onAddElement(thing);
    }

    private void addThingsToBridge(Bridge bridge) {
        Collection things = this.getAll();
        for (Thing thing : things) {
            ThingUID bridgeUID = thing.getBridgeUID();
            if (bridgeUID == null || !bridgeUID.equals(bridge.getUID()) || !(bridge instanceof BridgeImpl) || bridge.getThings().contains(thing)) continue;
            ((BridgeImpl)bridge).addThing(thing);
        }
    }

    private void addThingToBridge(Thing thing) {
        Thing bridge;
        ThingUID bridgeUID = thing.getBridgeUID();
        if (bridgeUID != null && (bridge = this.getByUID(bridgeUID)) instanceof BridgeImpl && !((Bridge)bridge).getThings().contains(thing)) {
            ((BridgeImpl)bridge).addThing(thing);
        }
    }

    private void notifyTrackers(Thing thing, ThingTracker.ThingTrackerEvent event) {
        for (ThingTracker thingTracker : this.thingTrackers) {
            try {
                switch (event) {
                    case THING_ADDED: {
                        thingTracker.thingAdded(thing, ThingTracker.ThingTrackerEvent.THING_ADDED);
                        break;
                    }
                    case THING_REMOVED: {
                        thingTracker.thingRemoved(thing, ThingTracker.ThingTrackerEvent.THING_REMOVED);
                        break;
                    }
                    case THING_UPDATED: {
                        thingTracker.thingUpdated(thing, ThingTracker.ThingTrackerEvent.THING_UPDATED);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Could not inform the ThingTracker '" + thingTracker + "' about the '" + event.name() + "' event!", (Throwable)ex);
            }
        }
    }

    private void notifyTrackerAboutAllThingsAdded(ThingTracker thingTracker) {
        for (Thing thing : this.getAll()) {
            thingTracker.thingAdded(thing, ThingTracker.ThingTrackerEvent.TRACKER_ADDED);
        }
    }

    private void notifyTrackerAboutAllThingsRemoved(ThingTracker thingTracker) {
        for (Thing thing : this.getAll()) {
            thingTracker.thingRemoved(thing, ThingTracker.ThingTrackerEvent.TRACKER_REMOVED);
        }
    }
}

