/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingHelper {
    private static final Logger logger = LoggerFactory.getLogger(ThingHelper.class);
    private BundleContext bundleContext;

    public ThingHelper(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void createAndBindItems(Thing thing) {
        List<ItemFactory> itemFactories = this.getItemFactories();
        if (itemFactories.isEmpty()) {
            logger.warn("No ItemFactory has been registered. It's not possible to create items.");
            return;
        }
        ManagedItemProvider managedItemProvider = this.getManagedItemProvider();
        ManagedItemChannelLinkProvider managedItemChannelLinkProvider = this.getManagedItemChannelLinkProvider();
        List<Channel> channels = thing.getChannels();
        for (Channel channel : channels) {
            String acceptedItemType = channel.getAcceptedItemType();
            ItemFactory itemFactory = this.getItemFactoryForItemType(itemFactories, acceptedItemType);
            if (itemFactory == null) {
                logger.warn("No ItemFactory supports the item type '{}'. It's not possible to create an item for the channel '{}'.", (Object)acceptedItemType, (Object)channel.getUID());
                continue;
            }
            GenericItem item = itemFactory.createItem(acceptedItemType, this.toItemName(channel));
            if (item == null) {
                logger.error("The item of type '{}' has not been created by the ItemFactory '{}'.", (Object)acceptedItemType, (Object)itemFactory.getClass().getName());
                continue;
            }
            managedItemProvider.add((Object)item);
            managedItemChannelLinkProvider.add(new ItemChannelLink(item.getName(), channel.getUID()));
        }
    }

    private String toItemName(Channel channel) {
        String channelUID = channel.getUID().toString();
        String itemName = channelUID.replaceAll("[^a-zA-Z0-9_]", "_");
        return itemName;
    }

    private ManagedItemProvider getManagedItemProvider() {
        ServiceReference managedItemProviderServiceRef = this.bundleContext.getServiceReference(ManagedItemProvider.class.getName());
        if (managedItemProviderServiceRef == null) {
            return null;
        }
        ManagedItemProvider managedItemProvider = (ManagedItemProvider)this.bundleContext.getService(managedItemProviderServiceRef);
        return managedItemProvider;
    }

    private ManagedItemChannelLinkProvider getManagedItemChannelLinkProvider() {
        ServiceReference managedItemChannelLinkProviderRef = this.bundleContext.getServiceReference(ManagedItemChannelLinkProvider.class.getName());
        if (managedItemChannelLinkProviderRef == null) {
            return null;
        }
        ManagedItemChannelLinkProvider managedItemChannelLinkProvider = (ManagedItemChannelLinkProvider)this.bundleContext.getService(managedItemChannelLinkProviderRef);
        return managedItemChannelLinkProvider;
    }

    private List<ItemFactory> getItemFactories() {
        ArrayList<ItemFactory> itemFactories = new ArrayList<ItemFactory>();
        ServiceReference[] itemFactoryServiceRefs = null;
        try {
            itemFactoryServiceRefs = this.bundleContext.getServiceReferences(ItemFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error("The item factories cannot be obtained.", (Throwable)e);
        }
        if (itemFactoryServiceRefs == null) {
            return itemFactories;
        }
        ServiceReference[] serviceReferenceArray = itemFactoryServiceRefs;
        int n = itemFactoryServiceRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            itemFactories.add((ItemFactory)this.bundleContext.getService(serviceReference));
            ++n2;
        }
        return itemFactories;
    }

    private ItemFactory getItemFactoryForItemType(List<ItemFactory> itemFactories, String itemType) {
        for (ItemFactory itemFactory : itemFactories) {
            String[] supportedItemTypes = itemFactory.getSupportedItemTypes();
            int i = 0;
            while (i < supportedItemTypes.length) {
                String supportedItemType = supportedItemTypes[i];
                if (supportedItemType.equals(itemType)) {
                    return itemFactory;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean equals(Thing a, Thing b) {
        if (!a.getUID().equals(b.getUID())) {
            return false;
        }
        if (a.getName() == null && b.getName() != null) {
            return false;
        }
        if (a.getName() != null && !a.getName().equals(b.getName())) {
            return false;
        }
        if (a.getBridgeUID() == null && b.getBridgeUID() != null) {
            return false;
        }
        if (a.getBridgeUID() != null && !a.getBridgeUID().equals(b.getBridgeUID())) {
            return false;
        }
        if (a.getConfiguration() == null && b.getConfiguration() != null) {
            return false;
        }
        if (a.getConfiguration() != null && !a.getConfiguration().equals((Object)b.getConfiguration())) {
            return false;
        }
        List<Channel> channelsOfA = a.getChannels();
        List<Channel> channelsOfB = b.getChannels();
        if (channelsOfA.size() != channelsOfB.size()) {
            return false;
        }
        return ThingHelper.toString(channelsOfA).equals(ThingHelper.toString(channelsOfB));
    }

    private static String toString(List<Channel> channels) {
        ArrayList<String> strings = new ArrayList<String>(channels.size());
        for (Channel channel : channels) {
            strings.add(String.valueOf(channel.getUID().toString()) + '#' + channel.getAcceptedItemType());
        }
        Collections.sort(strings);
        return Joiner.on((char)',').join(strings);
    }
}

