/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.core.internal.folder;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.ConfigDispatcher;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderObserver
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(FolderObserver.class);
    private WatchService watchService;
    private ModelRepository modelRepo = null;
    private final Map<String, String[]> folderFileExtMap = new ConcurrentHashMap<String, String[]>();

    public void setModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
    }

    public void unsetModelRepository(ModelRepository modelRepo) {
        this.modelRepo = null;
    }

    public void activate() {
    }

    public void deactivate() {
        this.stopWatchService();
    }

    private void initializeWatchService() {
        String pathToWatch;
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                logger.warn("Cannot deactivate folder watcher", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)(pathToWatch = ConfigDispatcher.getConfigFolder())) && MapUtils.isNotEmpty(this.folderFileExtMap)) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
                Files.walkFileTree(Paths.get(pathToWatch, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String folderName = dir.getFileName().toString();
                        if (FolderObserver.this.folderFileExtMap.containsKey(folderName)) {
                            dir.register(FolderObserver.this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                WatchQueueReader reader = new WatchQueueReader(this.watchService, this.folderFileExtMap, this.modelRepo);
                Thread qr = new Thread((Runnable)reader, "Model Dir Watcher");
                qr.start();
            }
            catch (IOException e) {
                logger.error("Cannot activate folder watcher for folder ", (Throwable)e);
            }
        }
    }

    private void stopWatchService() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                logger.warn("Cannot deactivate folder watcher", (Throwable)e);
            }
            this.watchService = null;
        }
    }

    public synchronized void updated(Dictionary config) throws ConfigurationException {
        if (config != null) {
            ConcurrentHashMap<String, String[]> previousFolderFileExtMap = new ConcurrentHashMap<String, String[]>(this.folderFileExtMap);
            this.folderFileExtMap.clear();
            Enumeration keys = config.keys();
            while (keys.hasMoreElements()) {
                String foldername = (String)keys.nextElement();
                if (foldername.equals("service.pid")) continue;
                String[] fileExts = ((String)config.get(foldername)).split(",");
                File folder = FolderObserver.getFile(foldername);
                if (folder.exists() && folder.isDirectory()) {
                    this.folderFileExtMap.put(foldername, fileExts);
                    continue;
                }
                logger.warn("Directory '{}' does not exist in '{}'. Please check your configuration settings!", (Object)foldername, (Object)ConfigDispatcher.getConfigFolder());
            }
            this.notifyUpdateToModelRepo(previousFolderFileExtMap);
            this.initializeWatchService();
        }
    }

    private void notifyUpdateToModelRepo(Map<String, String[]> previousFolderFileExtMap) {
        this.checkDeletedModels(previousFolderFileExtMap);
        if (MapUtils.isNotEmpty(this.folderFileExtMap)) {
            for (String folderName : this.folderFileExtMap.keySet()) {
                File folder;
                File[] files;
                String[] validExtension = this.folderFileExtMap.get(folderName);
                if (validExtension == null || validExtension.length <= 0 || (files = (folder = FolderObserver.getFile(folderName)).listFiles(new FileExtensionsFilter(validExtension))) == null || files.length <= 0) continue;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    FolderObserver.checkFile(this.modelRepo, file, StandardWatchEventKinds.ENTRY_CREATE);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkDeletedModels(Map<String, String[]> previousFolderFileExtMap) {
        block11: {
            block10: {
                if (MapUtils.isNotEmpty(previousFolderFileExtMap) == false) return;
                modelsToRemove = new LinkedList<E>();
                if (!MapUtils.isNotEmpty(this.folderFileExtMap)) break block10;
                folders = previousFolderFileExtMap.keySet();
                var5_4 = folders.iterator();
                if (true) ** GOTO lbl15
            }
            folders = previousFolderFileExtMap.keySet();
            var5_4 = folders.iterator();
            if (true) ** GOTO lbl31
            do {
                if (this.folderFileExtMap.containsKey(folder = var5_4.next()) || (models = this.modelRepo.getAllModelNamesOfType(folder)) == null) continue;
                modelsToRemove.addAll(Lists.newLinkedList(models));
lbl15:
                // 3 sources

            } while (var5_4.hasNext());
            break block11;
            do {
                folder = var5_4.next();
                var6_6 = FolderObserver.class;
                // MONITORENTER : org.eclipse.smarthome.model.core.internal.folder.FolderObserver.class
                models = this.modelRepo.getAllModelNamesOfType(folder);
                if (models != null) {
                    modelsToRemove.addAll(Lists.newLinkedList(models));
                }
                // MONITOREXIT : var6_6
lbl31:
                // 2 sources

            } while (var5_4.hasNext());
        }
        if (CollectionUtils.isNotEmpty(modelsToRemove) == false) return;
        for (String modelToRemove : modelsToRemove) {
            var5_4 = FolderObserver.class;
            // MONITORENTER : org.eclipse.smarthome.model.core.internal.folder.FolderObserver.class
            this.modelRepo.removeModel(modelToRemove);
            // MONITOREXIT : var5_4
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFile(ModelRepository modelRepo, File file, WatchEvent.Kind kind) {
        if (modelRepo != null && file != null) {
            try {
                Class<FolderObserver> clazz = FolderObserver.class;
                synchronized (FolderObserver.class) {
                    if ((kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) && file != null) {
                        modelRepo.addOrRefreshModel(file.getName(), FileUtils.openInputStream((File)file));
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        modelRepo.removeModel(file.getName());
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (IOException e) {
                logger.warn("Cannot open file '" + file.getAbsolutePath() + "' for reading.", (Throwable)e);
            }
        }
        {
            return;
        }
    }

    private static File getFileByFileExtMap(Map<String, String[]> folderFileExtMap, String filename) {
        String extension;
        if (StringUtils.isNotBlank((String)filename) && MapUtils.isNotEmpty(folderFileExtMap) && StringUtils.isNotBlank((String)(extension = FolderObserver.getExtension(filename)))) {
            Set<Map.Entry<String, String[]>> entries = folderFileExtMap.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                if (!ArrayUtils.contains((Object[])entry.getValue(), (Object)extension)) continue;
                return new File(FolderObserver.getFile(entry.getKey()) + File.separator + filename);
            }
        }
        return null;
    }

    public static File getFile(String filename) {
        File folder = new File(String.valueOf(ConfigDispatcher.getConfigFolder()) + File.separator + filename);
        return folder;
    }

    public static String getExtension(String filename) {
        String fileExt = filename.substring(filename.lastIndexOf(".") + 1);
        return fileExt;
    }

    protected class FileExtensionsFilter
    implements FilenameFilter {
        private String[] validExtensions;

        public FileExtensionsFilter(String[] validExtensions) {
            this.validExtensions = validExtensions;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.validExtensions != null && this.validExtensions.length > 0) {
                String[] stringArray = this.validExtensions;
                int n = this.validExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (name.toLowerCase().endsWith("." + extension)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private static class WatchQueueReader
    implements Runnable {
        private WatchService watchService;
        private Map<String, String[]> folderFileExtMap = new ConcurrentHashMap<String, String[]>();
        private ModelRepository modelRepo = null;

        public WatchQueueReader(WatchService watchService, Map<String, String[]> folderFileExtMap, ModelRepository modelRepo) {
            this.watchService = watchService;
            this.folderFileExtMap = folderFileExtMap;
            this.modelRepo = modelRepo;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    WatchKey key = null;
                    try {
                        key = this.watchService.take();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent<?> ev;
                        Path name;
                        File toCheck;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW || (toCheck = FolderObserver.getFileByFileExtMap(this.folderFileExtMap, (name = (Path)(ev = event).context()).toString())) == null) continue;
                        FolderObserver.checkFile(this.modelRepo, toCheck, kind);
                    }
                    key.reset();
                }
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                logger.debug("Terminated thread {}", (Object)Thread.currentThread().getName());
                return;
            }
        }
    }
}

