/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler.internal;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchedulerActivator
implements BundleActivator {
    private static Logger logger = LoggerFactory.getLogger(SchedulerActivator.class);
    private static BundleContext context;

    public void start(BundleContext bc) throws Exception {
        context = bc;
        logger.debug("Scheduler has been started.");
        try {
            StdSchedulerFactory.getDefaultScheduler().start();
        }
        catch (SchedulerException se) {
            logger.error("initializing scheduler throws exception", (Throwable)se);
        }
    }

    public void stop(BundleContext bc) throws Exception {
        context = null;
        logger.debug("Scheduler has been stopped.");
        try {
            StdSchedulerFactory.getDefaultScheduler().shutdown();
        }
        catch (SchedulerException se) {
            logger.error("shutting down scheduler throws exception", (Throwable)se);
        }
    }

    public static BundleContext getContext() {
        return context;
    }
}

