/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.events;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.EventType;
import org.eclipse.smarthome.core.types.State;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventPublisherImpl
implements EventPublisher {
    private EventAdmin eventAdmin;

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    @Override
    public void sendCommand(final String itemName, final Command command, final String source) throws IllegalArgumentException, IllegalStateException {
        ItemUtil.assertValidItemName(itemName);
        if (command == null) {
            throw new IllegalArgumentException("The command must not be null!");
        }
        final EventAdmin eventAdmin = this.eventAdmin;
        if (eventAdmin != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        eventAdmin.sendEvent(EventPublisherImpl.this.createCommandEvent(itemName, command, source));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                throw new IllegalStateException("Cannot send the command!", ex);
            }
        } else {
            throw new IllegalStateException("The event bus module is not available!");
        }
    }

    @Override
    public void postCommand(final String itemName, final Command command, final String source) throws IllegalArgumentException, IllegalStateException {
        ItemUtil.assertValidItemName(itemName);
        if (command == null) {
            throw new IllegalArgumentException("The command must not be null!");
        }
        final EventAdmin eventAdmin = this.eventAdmin;
        if (eventAdmin != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        eventAdmin.postEvent(EventPublisherImpl.this.createCommandEvent(itemName, command, source));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                throw new IllegalStateException("Cannot post the command!", ex);
            }
        } else {
            throw new IllegalStateException("The event bus module is not available!");
        }
    }

    @Override
    public void postUpdate(final String itemName, final State newState, final String source) throws IllegalArgumentException, IllegalStateException {
        ItemUtil.assertValidItemName(itemName);
        if (newState == null) {
            throw new IllegalArgumentException("The state must not be null!");
        }
        final EventAdmin eventAdmin = this.eventAdmin;
        if (eventAdmin != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        eventAdmin.postEvent(EventPublisherImpl.this.createUpdateEvent(itemName, newState, source));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                throw new IllegalStateException("Cannot post the update!", ex);
            }
        } else {
            throw new IllegalStateException("The event bus module is not available!");
        }
    }

    private String createTopic(EventType type, String itemName) {
        return "smarthome/" + (Object)((Object)type) + "/" + itemName;
    }

    private Event createCommandEvent(String itemName, Command command, String source) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(2);
        ((Dictionary)properties).put("item", itemName);
        ((Dictionary)properties).put("command", command);
        if (source != null) {
            ((Dictionary)properties).put("source", source);
        }
        return new Event(this.createTopic(EventType.COMMAND, itemName), properties);
    }

    private Event createUpdateEvent(String itemName, State newState, String source) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(2);
        ((Dictionary)properties).put("item", itemName);
        ((Dictionary)properties).put("state", newState);
        if (source != null) {
            ((Dictionary)properties).put("source", source);
        }
        return new Event(this.createTopic(EventType.UPDATE, itemName), properties);
    }

    @Override
    public void sendCommand(String itemName, Command command) throws IllegalArgumentException, IllegalStateException {
        this.sendCommand(itemName, command, null);
    }

    @Override
    public void postCommand(String itemName, Command command) throws IllegalArgumentException, IllegalStateException {
        this.postCommand(itemName, command, null);
    }

    @Override
    public void postUpdate(String itemName, State newState) throws IllegalArgumentException, IllegalStateException {
        this.postUpdate(itemName, newState, null);
    }
}

