/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;

public class ItemChannelLinkRegistry
extends AbstractRegistry<ItemChannelLink> {
    private ThingRegistry thingRegistry;

    public Set<ChannelUID> getBoundChannels(String itemName) {
        HashSet<ChannelUID> channelUIDs = new HashSet<ChannelUID>();
        for (ItemChannelLink itemChannelLink : this.getAll()) {
            if (!itemChannelLink.getItemName().equals(itemName)) continue;
            channelUIDs.add(itemChannelLink.getChannelUID());
        }
        return channelUIDs;
    }

    public String getBoundItem(ChannelUID channelUID) {
        for (ItemChannelLink itemChannelLink : this.getAll()) {
            if (!itemChannelLink.getChannelUID().equals(channelUID)) continue;
            return itemChannelLink.getItemName();
        }
        return null;
    }

    public Set<Thing> getBoundThings(String itemName) {
        HashSet<Thing> things = new HashSet<Thing>();
        Set<ChannelUID> boundChannels = this.getBoundChannels(itemName);
        for (ChannelUID channelUID : boundChannels) {
            Thing thing = this.thingRegistry.getByUID(channelUID.getThingUID());
            if (thing == null) continue;
            things.add(thing);
        }
        return things;
    }

    public boolean isLinked(String itemName, ChannelUID channelUID) {
        for (ItemChannelLink itemChannelLink : this.getAll()) {
            if (!itemChannelLink.getChannelUID().equals(channelUID) || !itemChannelLink.getItemName().equals(itemName)) continue;
            return true;
        }
        return false;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }
}

