/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.AbstractDescriptionType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;

public class ThingType
extends AbstractDescriptionType {
    private final List<ChannelDefinition> channelDefinitions;
    private final List<String> supportedBridgeTypeUIDs;

    public ThingType(String bindingId, String thingTypeId, String label) throws IllegalArgumentException {
        this(new ThingTypeUID(bindingId, thingTypeId), null, label, null, null, null);
    }

    public ThingType(ThingTypeUID uid, List<String> supportedBridgeTypeUIDs, String label, String description, List<ChannelDefinition> channelDefinitions, URI configDescriptionURI) throws IllegalArgumentException {
        super(uid, label, description, configDescriptionURI);
        this.supportedBridgeTypeUIDs = supportedBridgeTypeUIDs != null ? Collections.unmodifiableList(supportedBridgeTypeUIDs) : Collections.unmodifiableList(new ArrayList(0));
        this.channelDefinitions = channelDefinitions != null ? Collections.unmodifiableList(channelDefinitions) : Collections.unmodifiableList(new ArrayList(0));
    }

    @Override
    public ThingTypeUID getUID() {
        return (ThingTypeUID)super.getUID();
    }

    public String getBindingId() {
        return this.getUID().getBindingId();
    }

    public List<String> getSupportedBridgeTypeUIDs() {
        return this.supportedBridgeTypeUIDs;
    }

    public List<ChannelDefinition> getChannelDefinitions() {
        return this.channelDefinitions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingType other = (ThingType)obj;
        return this.getUID().equals(other.getUID());
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public String toString() {
        return this.getUID().toString();
    }
}

