/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.item.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.ItemsChangeListener;
import org.eclipse.smarthome.core.library.types.ArithmeticGroupFunction;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.item.BindingConfigParseException;
import org.eclipse.smarthome.model.item.BindingConfigReader;
import org.eclipse.smarthome.model.items.ItemModel;
import org.eclipse.smarthome.model.items.ModelBinding;
import org.eclipse.smarthome.model.items.ModelGroupFunction;
import org.eclipse.smarthome.model.items.ModelGroupItem;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.items.ModelNormalItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericItemProvider
extends AbstractProvider<Item>
implements ModelRepositoryChangeListener,
ItemProvider {
    private static final Logger logger = LoggerFactory.getLogger(GenericItemProvider.class);
    private Map<String, BindingConfigReader> bindingConfigReaders = new HashMap<String, BindingConfigReader>();
    private ModelRepository modelRepository = null;
    private Collection<ItemFactory> itemFactorys = new ArrayList<ItemFactory>();

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void addItemFactory(ItemFactory factory) {
        this.itemFactorys.add(factory);
        this.dispatchBindingsPerItemType(null, factory.getSupportedItemTypes());
    }

    public void removeItemFactory(ItemFactory factory) {
        this.itemFactorys.remove(factory);
    }

    public void addBindingConfigReader(BindingConfigReader reader) {
        if (!this.bindingConfigReaders.containsKey(reader.getBindingType())) {
            this.bindingConfigReaders.put(reader.getBindingType(), reader);
            this.dispatchBindingsPerType(reader, new String[]{reader.getBindingType()});
        } else {
            logger.warn("Attempted to register a second BindingConfigReader of type '{}'. The primaraly reader will remain active!", (Object)reader.getBindingType());
        }
    }

    public void removeBindingConfigReader(BindingConfigReader reader) {
        if (this.bindingConfigReaders.get(reader.getBindingType()).equals(reader)) {
            this.bindingConfigReaders.remove(reader.getBindingType());
        }
    }

    public Collection<Item> getAll() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String name : this.modelRepository.getAllModelNamesOfType("items")) {
            items.addAll(this.getItemsFromModel(name));
        }
        return items;
    }

    private Collection<Item> getItemsFromModel(String modelName) {
        ItemModel model;
        logger.debug("Read items from model '{}'", (Object)modelName);
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.modelRepository != null && (model = (ItemModel)this.modelRepository.getModel(modelName)) != null) {
            for (ModelItem modelItem : model.getItems()) {
                Item item = this.createItemFromModelItem(modelItem);
                if (item == null) continue;
                for (String groupName : modelItem.getGroups()) {
                    ((GenericItem)item).addGroupName(groupName);
                }
                items.add(item);
            }
        }
        return items;
    }

    private void processBindingConfigsFromModel(String modelName) {
        logger.debug("Processing binding configs for items from model '{}'", (Object)modelName);
        if (this.modelRepository != null) {
            ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
            if (model == null) {
                return;
            }
            for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
                reader.removeConfigurations(modelName);
            }
            for (ModelItem modelItem : model.getItems()) {
                Item item = this.createItemFromModelItem(modelItem);
                if (item == null) continue;
                this.internalDispatchBindings(modelName, item, modelItem.getBindings());
            }
        }
    }

    private Item createItemFromModelItem(ModelItem modelItem) {
        GenericItem item = null;
        if (modelItem instanceof ModelGroupItem) {
            ModelGroupFunction function;
            ModelGroupItem modelGroupItem = (ModelGroupItem)modelItem;
            String baseItemType = modelGroupItem.getType();
            GenericItem baseItem = this.createItemOfType(baseItemType, modelGroupItem.getName());
            item = baseItem != null ? ((function = modelGroupItem.getFunction()) == null ? new GroupItem(modelGroupItem.getName(), baseItem) : this.applyGroupFunction(baseItem, modelGroupItem, function)) : new GroupItem(modelGroupItem.getName());
        } else {
            ModelNormalItem normalItem = (ModelNormalItem)modelItem;
            String itemName = normalItem.getName();
            item = this.createItemOfType(normalItem.getType(), itemName);
        }
        return item;
    }

    private GroupItem applyGroupFunction(GenericItem baseItem, ModelGroupItem modelGroupItem, ModelGroupFunction function) {
        ArrayList<State> args = new ArrayList<State>();
        for (String arg : modelGroupItem.getArgs()) {
            State state = TypeParser.parseState((List)baseItem.getAcceptedDataTypes(), (String)arg);
            if (state == null) {
                logger.warn("State '{}' is not valid for group item '{}' with base type '{}'", new Object[]{arg, modelGroupItem.getName(), modelGroupItem.getType()});
                args.clear();
                break;
            }
            args.add(state);
        }
        ArithmeticGroupFunction.Avg groupFunction = null;
        switch (function) {
            case AND: {
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.And((State)args.get(0), (State)args.get(1));
                    break;
                }
                logger.error("Group function 'AND' requires two arguments. Using Equality instead.");
            }
            case OR: {
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.Or((State)args.get(0), (State)args.get(1));
                    break;
                }
                logger.error("Group function 'OR' requires two arguments. Using Equality instead.");
            }
            case NAND: {
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.NAnd((State)args.get(0), (State)args.get(1));
                    break;
                }
                logger.error("Group function 'NOT AND' requires two arguments. Using Equality instead.");
                break;
            }
            case NOR: {
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.NOr((State)args.get(0), (State)args.get(1));
                    break;
                }
                logger.error("Group function 'NOT OR' requires two arguments. Using Equality instead.");
            }
            case AVG: {
                groupFunction = new ArithmeticGroupFunction.Avg();
                break;
            }
            case SUM: {
                groupFunction = new ArithmeticGroupFunction.Sum();
                break;
            }
            case MIN: {
                groupFunction = new ArithmeticGroupFunction.Min();
                break;
            }
            case MAX: {
                groupFunction = new ArithmeticGroupFunction.Max();
                break;
            }
            default: {
                logger.error("Unknown group function '" + function.getName() + "'. Using Equality instead.");
            }
        }
        if (groupFunction == null) {
            groupFunction = new GroupFunction.Equality();
        }
        return new GroupItem(modelGroupItem.getName(), baseItem, (GroupFunction)groupFunction);
    }

    private void dispatchBindingsPerItemType(BindingConfigReader reader, String[] itemTypes) {
        if (this.modelRepository != null) {
            for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
                ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    for (ModelItem modelItem : model.getItems()) {
                        String[] stringArray = itemTypes;
                        int n = itemTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String itemType = stringArray[n2];
                            if (itemType.equals(modelItem.getType())) {
                                Item item = this.createItemFromModelItem(modelItem);
                                this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                            }
                            ++n2;
                        }
                    }
                    continue;
                }
                logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
            }
        } else {
            logger.warn("ModelRepository is NULL > dispatch bindings aborted!");
        }
    }

    private void dispatchBindingsPerType(BindingConfigReader reader, String[] bindingTypes) {
        if (this.modelRepository != null) {
            for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
                ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    for (ModelItem modelItem : model.getItems()) {
                        for (ModelBinding modelBinding : modelItem.getBindings()) {
                            String[] stringArray = bindingTypes;
                            int n = bindingTypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String bindingType = stringArray[n2];
                                if (bindingType.equals(modelBinding.getType())) {
                                    Item item = this.createItemFromModelItem(modelItem);
                                    this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                                }
                                ++n2;
                            }
                        }
                    }
                    continue;
                }
                logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
            }
        } else {
            logger.warn("ModelRepository is NULL > dispatch bindings aborted!");
        }
    }

    private void internalDispatchBindings(String modelName, Item item, EList<ModelBinding> bindings) {
        this.internalDispatchBindings(null, modelName, item, bindings);
    }

    private void internalDispatchBindings(BindingConfigReader reader, String modelName, Item item, EList<ModelBinding> bindings) {
        for (ModelBinding binding : bindings) {
            String bindingType = binding.getType();
            String config = binding.getConfiguration();
            BindingConfigReader localReader = reader;
            if (reader == null) {
                logger.trace("Given binding config reader is null > query cache to find appropriate reader!");
                localReader = this.bindingConfigReaders.get(bindingType);
            } else {
                if (!localReader.getBindingType().equals(binding.getType())) {
                    logger.trace("The Readers' binding type '{}' and the Bindings' type '{}' doesn't match > continue processing next binding.", (Object)localReader.getBindingType(), (Object)binding.getType());
                    continue;
                }
                logger.debug("Start processing binding configuration of Item '{}' with '{}' reader.", (Object)item, (Object)localReader.getClass().getSimpleName());
            }
            if (localReader != null) {
                try {
                    localReader.validateItemType(item.getType(), config);
                    localReader.processBindingConfiguration(modelName, item.getType(), item.getName(), config);
                }
                catch (BindingConfigParseException e) {
                    logger.error("Binding configuration of type '" + bindingType + "' of item \u2018" + item.getName() + "\u2018 could not be parsed correctly.", (Throwable)e);
                }
                continue;
            }
            logger.trace("Couldn't find config reader for binding type '{}' > parsing binding configuration of Iten '{}' aborted!", (Object)bindingType, (Object)item);
        }
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith("items")) {
            this.processBindingConfigsFromModel(modelName);
            for (ProviderChangeListener listener : this.listeners) {
                if (!(listener instanceof ItemsChangeListener)) continue;
                ((ItemsChangeListener)listener).allItemsChanged((ItemProvider)this, null);
            }
        }
    }

    private GenericItem createItemOfType(String itemType, String itemName) {
        if (itemType == null) {
            return null;
        }
        for (ItemFactory factory : this.itemFactorys) {
            GenericItem item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            logger.trace("Created item '{}' of type '{}'", (Object)itemName, (Object)itemType);
            return item;
        }
        logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }
}

