/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.smarthome.designer.ui.UIActivator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ViewLabelProvider
extends LabelProvider {
    private Map<String, Image> imageCache = new HashMap<String, Image>();

    public void dispose() {
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
    }

    public String getText(Object obj) {
        if (obj instanceof IFolder) {
            IResource res = (IResource)obj;
            return StringUtils.capitalize((String)res.getName());
        }
        if (obj instanceof IFile) {
            IResource res = (IResource)obj;
            return res.getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof IFolder) {
            IFolder folder = (IFolder)obj;
            String name = folder.getName().toLowerCase();
            Image image = this.imageCache.get(name);
            if (image == null) {
                ImageDescriptor imageDesc = UIActivator.getImageDescriptor("icons/" + name + ".png");
                if (imageDesc != null) {
                    image = imageDesc.createImage();
                    this.imageCache.put(name, image);
                    return image;
                }
            } else {
                return image;
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            String fileExt = file.getFileExtension();
            Image image = this.imageCache.get(fileExt);
            if (image == null) {
                ImageDescriptor imageDesc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor("." + fileExt);
                image = imageDesc.createImage();
                this.imageCache.put(fileExt, image);
            }
            return image;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }
}

