/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.internal.ConfigActivator;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDispatcher {
    private static final String PID_MARKER = "pid:";
    private static final Logger logger = LoggerFactory.getLogger(ConfigDispatcher.class);
    private static WatchService watchService;
    private static String configFolder;

    static {
        configFolder = "conf";
    }

    public void activate() {
        ConfigDispatcher.initializeWatchService();
        this.readDefaultConfig();
        this.readConfigs();
    }

    public void deactivate() {
        this.stopWatchService();
    }

    public static String getConfigFolder() {
        String progArg = System.getProperty("smarthome.configdir");
        if (progArg != null) {
            return progArg;
        }
        return configFolder;
    }

    public static void setConfigFolder(String configFolder) {
        ConfigDispatcher.configFolder = configFolder;
        ConfigDispatcher.initializeWatchService();
    }

    private static String getDefaultServiceConfigFile() {
        String progArg = System.getProperty("smarthome.servicecfg");
        if (progArg != null) {
            return progArg;
        }
        return String.valueOf(ConfigDispatcher.getConfigFolder()) + "/" + "smarthome.cfg";
    }

    private void readDefaultConfig() {
        File defaultCfg = new File(ConfigDispatcher.getDefaultServiceConfigFile());
        try {
            ConfigDispatcher.processConfigFile(defaultCfg);
        }
        catch (IOException e) {
            logger.warn("Could not process default config file '{}': {}", (Object)ConfigDispatcher.getDefaultServiceConfigFile(), (Object)e);
        }
    }

    private void readConfigs() {
        File dir = new File(ConfigDispatcher.getServiceConfigFolder());
        if (dir.exists()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    ConfigDispatcher.processConfigFile(file);
                }
                catch (IOException e) {
                    logger.warn("Could not process config file '{}': {}", (Object)file.getName(), (Object)e);
                }
                ++n2;
            }
        } else {
            logger.debug("Configuration folder '{}' does not exist.", (Object)dir.toString());
        }
    }

    private static void initializeWatchService() {
        Path toWatch;
        if (watchService != null) {
            try {
                watchService.close();
            }
            catch (IOException e) {
                logger.warn("Cannot deactivate folder watcher", (Throwable)e);
            }
        }
        if ((toWatch = Paths.get(ConfigDispatcher.getServiceConfigFolder(), new String[0])).toFile().exists()) {
            try {
                watchService = toWatch.getFileSystem().newWatchService();
                WatchQueueReader reader = new WatchQueueReader(watchService, toWatch);
                Thread qr = new Thread((Runnable)reader, "Dir Watcher");
                qr.start();
                toWatch.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            catch (IOException e) {
                logger.error("Cannot activate folder watcher for folder '{}': ", (Object)toWatch, (Object)e);
            }
        }
    }

    private void stopWatchService() {
        if (watchService != null) {
            try {
                watchService.close();
            }
            catch (IOException e) {
                logger.warn("Cannot deactivate folder watcher", (Throwable)e);
            }
            watchService = null;
        }
    }

    private static String getServiceConfigFolder() {
        String progArg = System.getProperty("smarthome.servicedir");
        if (progArg != null) {
            return String.valueOf(ConfigDispatcher.getConfigFolder()) + "/" + progArg;
        }
        return String.valueOf(ConfigDispatcher.getConfigFolder()) + "/" + "services";
    }

    private static String getServicePidNamespace() {
        String progArg = System.getProperty("smarthome.servicepid");
        if (progArg != null) {
            return progArg;
        }
        return "org.eclipse.smarthome";
    }

    private static void processConfigFile(File configFile) throws IOException, FileNotFoundException {
        if (configFile.isDirectory() || !configFile.getName().endsWith(".cfg")) {
            logger.debug("Ignoring file '{}'", (Object)configFile.getName());
            return;
        }
        logger.debug("Processing config file '{}'", (Object)configFile.getName());
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)ConfigActivator.configurationAdminTracker.getService();
        if (configurationAdmin != null) {
            HashMap<Configuration, Dictionary> configsToUpdate = new HashMap<Configuration, Dictionary>();
            HashMap<Configuration, Dictionary> configMap = new HashMap<Configuration, Dictionary>();
            String filenameWithoutExt = StringUtils.substringBeforeLast((String)configFile.getName(), (String)".");
            String pid = filenameWithoutExt.contains(".") ? filenameWithoutExt : String.valueOf(ConfigDispatcher.getServicePidNamespace()) + "." + filenameWithoutExt;
            List lines = IOUtils.readLines((InputStream)new FileInputStream(configFile));
            if (lines.size() > 0 && ((String)lines.get(0)).startsWith(PID_MARKER)) {
                pid = ((String)lines.get(0)).substring(PID_MARKER.length()).trim();
            }
            for (String string : lines) {
                String[] contents = ConfigDispatcher.parseLine(configFile.getPath(), string);
                if (contents == null) continue;
                if (contents[0] != null) {
                    pid = contents[0];
                }
                String property = contents[1];
                String value = contents[2];
                Configuration configuration = configurationAdmin.getConfiguration(pid, null);
                if (configuration == null) continue;
                Dictionary configProperties = (Dictionary)configMap.get(configuration);
                if (configProperties == null) {
                    configProperties = new Properties();
                    configMap.put(configuration, configProperties);
                }
                if (value.equals(configProperties.get(property))) continue;
                configProperties.put(property, value);
                configsToUpdate.put(configuration, configProperties);
            }
            for (Map.Entry entry : configsToUpdate.entrySet()) {
                ((Configuration)entry.getKey()).update((Dictionary)entry.getValue());
            }
        }
    }

    private static String[] parseLine(String filePath, String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("#") || trimmedLine.isEmpty()) {
            return null;
        }
        String pid = null;
        String key = StringUtils.substringBefore((String)trimmedLine, (String)"=");
        if (key.contains(":")) {
            pid = StringUtils.substringBefore((String)key, (String)":");
            trimmedLine = trimmedLine.substring(pid.length() + 1);
            pid = pid.trim();
        }
        if (!trimmedLine.isEmpty() && trimmedLine.substring(1).contains("=")) {
            String property = StringUtils.substringBefore((String)trimmedLine, (String)"=");
            String value = trimmedLine.substring(property.length() + 1);
            return new String[]{pid, property.trim(), value.trim()};
        }
        logger.warn("Could not parse line '{}'", (Object)line);
        return null;
    }

    private static class WatchQueueReader
    implements Runnable {
        private WatchService watchService;

        public WatchQueueReader(WatchService watchService, Path dir) {
            this.watchService = watchService;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    WatchKey key = null;
                    try {
                        key = this.watchService.take();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent ev = WatchQueueReader.cast(event);
                        Path name = (Path)ev.context();
                        if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        try {
                            ConfigDispatcher.processConfigFile(new File(String.valueOf(ConfigDispatcher.getServiceConfigFolder()) + File.separator + name.toString()));
                        }
                        catch (IOException e) {
                            logger.warn("Could not process config file '{}': {}", (Object)name, (Object)e);
                        }
                    }
                    key.reset();
                }
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                logger.debug("Terminated thread {}", (Object)Thread.currentThread().getName());
                return;
            }
        }

        static <T> WatchEvent<T> cast(WatchEvent<?> event) {
            return event;
        }
    }
}

