/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtext.common.types.ui.refactoring.participant.JdtRenameParticipant;
import org.eclipse.xtext.common.types.ui.refactoring.participant.TextChangeCombiner;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class CompositeRefactoringProcessor
extends AbstractRenameProcessor {
    @Inject
    private TextChangeCombiner textChangeCombiner;
    private Set<RefactoringProcessor> processors = Sets.newLinkedHashSet();
    private String newName;

    public boolean addProcessor(RefactoringProcessor processor) {
        return this.processors.add(processor);
    }

    public int getNumProcessors() {
        return this.processors.size();
    }

    public Object[] getElements() {
        ArrayList elements = Lists.newArrayList();
        for (RefactoringProcessor processor : this.processors) {
            Object[] objectArray = processor.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                elements.add(element);
                ++n2;
            }
        }
        return Iterables.toArray((Iterable)elements, Object.class);
    }

    public String getProcessorName() {
        return "Rename element and inferred Java artifacts";
    }

    public boolean isApplicable() throws CoreException {
        for (RefactoringProcessor processor : this.processors) {
            if (processor.isApplicable()) continue;
            return false;
        }
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.processors.size());
        RefactoringStatus status = new RefactoringStatus();
        for (RefactoringProcessor processor : this.processors) {
            status.merge(processor.checkInitialConditions((IProgressMonitor)monitor.newChild(1)));
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.processors.size());
        RefactoringStatus status = new RefactoringStatus();
        for (RefactoringProcessor processor : this.processors) {
            status.merge(processor.checkFinalConditions((IProgressMonitor)monitor.newChild(1), context));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.processors.size());
        CompositeChange compositeChange = new CompositeChange(this.getProcessorName());
        for (RefactoringProcessor processor : this.processors) {
            compositeChange.add(processor.createChange((IProgressMonitor)monitor.newChild(1)));
        }
        return this.textChangeCombiner.combineChanges((Change)compositeChange);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList participants = Lists.newArrayList();
        for (RefactoringProcessor processor : this.processors) {
            RefactoringParticipant[] refactoringParticipantArray = processor.loadParticipants(status, sharedParticipants);
            int n = refactoringParticipantArray.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringParticipant participant = refactoringParticipantArray[n2];
                if (!(participant instanceof JdtRenameParticipant)) {
                    participants.add(participant);
                }
                ++n2;
            }
        }
        return (RefactoringParticipant[])Iterables.toArray((Iterable)participants, RefactoringParticipant.class);
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean initialize(IRenameElementContext renameElementContext) {
        return false;
    }

    public String getOriginalName() {
        return null;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
        for (RefactoringProcessor processor : this.processors) {
            if (!(processor instanceof AbstractRenameProcessor)) continue;
            ((AbstractRenameProcessor)processor).setNewName(newName);
        }
    }

    public RefactoringStatus validateNewName(String newName) {
        RefactoringStatus status = new RefactoringStatus();
        for (RefactoringProcessor processor : this.processors) {
            if (!(processor instanceof AbstractRenameProcessor)) continue;
            status.merge(((AbstractRenameProcessor)processor).validateNewName(newName));
        }
        return status;
    }

    @Singleton
    public static class Access {
        private CompositeRefactoringProcessor current;
        private RefactoringProcessor currentJdtSourceRefactoringProcessor;
        @Inject
        private Provider<CompositeRefactoringProcessor> compositeRefactoringProvider;

        public CompositeRefactoringProcessor getCurrent(RefactoringProcessor jdtSourceRefactoring) {
            if (this.current == null || this.currentJdtSourceRefactoringProcessor != jdtSourceRefactoring) {
                this.current = (CompositeRefactoringProcessor)((Object)this.compositeRefactoringProvider.get());
                this.currentJdtSourceRefactoringProcessor = jdtSourceRefactoring;
            }
            return this.current;
        }

        public void disposeCurrent() {
            this.current = null;
            this.currentJdtSourceRefactoringProcessor = null;
        }

        public boolean isDisposed() {
            return this.current == null && this.currentJdtSourceRefactoringProcessor == null;
        }
    }
}

