/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.internal.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.ConsoleInterpreter;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class ConsoleCommandProvider
implements CommandProvider {
    protected Set<ConsoleCommandExtension> consoleCommandExtensions = new CopyOnWriteArraySet<ConsoleCommandExtension>();

    public Object _smarthome(CommandInterpreter interpreter) {
        String narg;
        String arg = interpreter.nextArgument();
        if (arg == null) {
            interpreter.println((Object)this.getHelp());
            return null;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(arg);
        OSGiConsole console = new OSGiConsole(interpreter);
        while (!StringUtils.isEmpty((String)(narg = interpreter.nextArgument()))) {
            argsList.add(narg);
        }
        String[] args = argsList.toArray(new String[argsList.size()]);
        ConsoleInterpreter.handleRequest(args, console, this.consoleCommandExtensions);
        return null;
    }

    public void addConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        this.consoleCommandExtensions.add(consoleCommandExtension);
    }

    public void removeConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        this.consoleCommandExtensions.remove(consoleCommandExtension);
    }

    public String getHelp() {
        List<String> usages = ConsoleInterpreter.getUsages(this.consoleCommandExtensions);
        StringBuffer buffer = new StringBuffer();
        buffer.append("---SmartHome commands---\n\t");
        int i = 0;
        while (i < usages.size()) {
            String usageString = usages.get(i);
            buffer.append("smarthome " + usageString + "\n");
            if (usages.size() > i + 1) {
                buffer.append("\t");
            }
            ++i;
        }
        return buffer.toString();
    }

    private static class OSGiConsole
    implements Console {
        private CommandInterpreter interpreter;

        public OSGiConsole(CommandInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        @Override
        public void print(String s) {
            this.interpreter.print((Object)s);
        }

        @Override
        public void println(String s) {
            this.interpreter.println((Object)s);
        }

        @Override
        public void printUsage(String s) {
            this.interpreter.println((Object)("Usage: smarthome " + s));
        }
    }
}

