/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private final Map<String, Object> properties;
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration() {
        this(new HashMap<String, Object>());
    }

    public Configuration(Map<String, Object> properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T as(Class<T> configurationClass) {
        Configuration configuration = this;
        synchronized (configuration) {
            Field[] declaredFields;
            T configuration2 = null;
            try {
                configuration2 = configurationClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                logger.error("Could not create configuration instance: " + ex.getMessage(), (Throwable)ex);
                return null;
            }
            Field[] fieldArray = declaredFields = configurationClass.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Object value = this.get(field.getName());
                if (value != null) {
                    try {
                        field.set(configuration2, value);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        logger.warn("Could not set field value for field '" + field.getName() + "': " + ex.getMessage(), (Throwable)ex);
                    }
                }
                ++n2;
            }
            return configuration2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(String key, Object value) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Configuration configuration = this;
        synchronized (configuration) {
            return ImmutableSet.copyOf(this.properties.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values() {
        Configuration configuration = this;
        synchronized (configuration) {
            return ImmutableList.copyOf(this.properties.values());
        }
    }

    public boolean isProperlyConfigured() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.hashCode();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }
}

