/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.IContextInformationAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContextInformationProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.ui.contentassist.ParameterContextInformation;
import org.eclipse.xtext.xbase.ui.contentassist.ParameterData;
import org.eclipse.xtext.xbase.ui.contentassist.XbaseProposalProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterContextInformationProvider
implements IContextInformationProvider {
    @Inject
    private XbaseProposalProvider proposalProvider;
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public void getContextInformation(ContentAssistContext context, IContextInformationAcceptor acceptor) {
        XExpression containerCall = this.getContainerCall(this.eObjectAtOffsetHelper.resolveContainedElementAt(context.getResource(), context.getOffset()));
        OwnedConverter converter = this.proposalProvider.getTypeConverter(context.getResource());
        if (containerCall != null) {
            ICompositeNode containerCallNode = NodeModelUtils.findActualNodeFor((EObject)containerCall);
            ITextRegion containerCallRegion = containerCallNode.getTextRegion();
            if (containerCallRegion.getOffset() > context.getOffset() || containerCallRegion.getOffset() + containerCallRegion.getLength() < context.getOffset()) {
                return;
            }
            JvmIdentifiableElement calledFeature = this.getCalledFeature(containerCall);
            if (calledFeature instanceof JvmExecutable) {
                if (this.getParameterListOffset(containerCall) > context.getOffset()) {
                    return;
                }
                ParameterData parameterData = new ParameterData();
                IScope scope = this.getScope(containerCall);
                QualifiedName qualifiedName = QualifiedName.create((String)this.getCalledFeatureName(containerCall));
                boolean candidatesFound = false;
                for (IEObjectDescription element : scope.getElements(qualifiedName)) {
                    JvmExecutable executable;
                    IIdentifiableElementDescription featureDescription;
                    JvmIdentifiableElement featureCandidate;
                    if (!(element instanceof IIdentifiableElementDescription) || !((featureCandidate = (featureDescription = (IIdentifiableElementDescription)element).getElementOrProxy()) instanceof JvmExecutable) || (executable = (JvmExecutable)featureCandidate).getParameters().isEmpty()) continue;
                    StyledString styledString = new StyledString();
                    this.proposalProvider.appendParameters(styledString, executable, featureDescription.getNumberOfIrrelevantParameters(), converter);
                    parameterData.addOverloaded(styledString.toString(), executable.isVarArgs());
                    candidatesFound = true;
                }
                if (candidatesFound) {
                    StyledString displayString = this.proposalProvider.getStyledDisplayString((JvmFeature)((JvmExecutable)calledFeature), true, 0, this.qualifiedNameConverter.toString(this.qualifiedNameProvider.getFullyQualifiedName((EObject)calledFeature)), calledFeature.getSimpleName(), converter);
                    ParameterContextInformation parameterContextInformation = new ParameterContextInformation(parameterData, displayString.toString(), this.getParameterListOffset(containerCall), context.getOffset());
                    acceptor.accept((IContextInformation)parameterContextInformation);
                }
            }
        }
    }

    protected XExpression getContainerCall(EObject element) {
        if (element == null || element instanceof XClosure) {
            return null;
        }
        if (element instanceof XConstructorCall || element instanceof XFeatureCall || element instanceof XMemberFeatureCall) {
            return (XExpression)element;
        }
        return this.getContainerCall(element.eContainer());
    }

    protected String getCalledFeatureName(XExpression call) {
        StringBuilder b = new StringBuilder();
        for (INode node : NodeModelUtils.findNodesForFeature((EObject)call, (EStructuralFeature)this.getCalledFeatureReference(call))) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                if (leafNode.isHidden()) continue;
                b.append(leafNode.getText());
            }
        }
        return b.toString();
    }

    protected JvmIdentifiableElement getCalledFeature(XExpression call) {
        if (call instanceof XConstructorCall) {
            return ((XConstructorCall)call).getConstructor();
        }
        if (call instanceof XFeatureCall || call instanceof XMemberFeatureCall) {
            return ((XAbstractFeatureCall)call).getFeature();
        }
        return null;
    }

    protected IScope getScope(XExpression containerCall) {
        IScopeProvider scopeProvider = this.proposalProvider.getScopeProvider();
        return scopeProvider.getScope((EObject)containerCall, this.getCalledFeatureReference(containerCall));
    }

    protected int getParameterListOffset(XExpression containerCall) {
        List<XExpression> arguments = this.getArguments(containerCall);
        if (arguments.isEmpty()) {
            Keyword parameterListOpenParenthesis = this.getParameterListOpenParenthesis(containerCall);
            for (ILeafNode leafNode : NodeModelUtils.findActualNodeFor((EObject)containerCall).getLeafNodes()) {
                if (leafNode.getGrammarElement() != parameterListOpenParenthesis) continue;
                return leafNode.getEndOffset();
            }
            int offset = 0;
            for (INode node : NodeModelUtils.findNodesForFeature((EObject)containerCall, (EStructuralFeature)this.getCalledFeatureReference(containerCall))) {
                offset = Math.max(offset, node.getEndOffset());
            }
            return offset;
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)((EObject)arguments.get(0)));
        return node.getOffset();
    }

    protected List<XExpression> getArguments(XExpression call) {
        if (call instanceof XFeatureCall) {
            return ((XFeatureCall)call).getFeatureCallArguments();
        }
        if (call instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)call).getMemberCallArguments();
        }
        if (call instanceof XConstructorCall) {
            return ((XConstructorCall)call).getArguments();
        }
        return Collections.emptyList();
    }

    protected EReference getCalledFeatureReference(XExpression call) {
        if (call instanceof XAbstractFeatureCall) {
            return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
        }
        if (call instanceof XConstructorCall) {
            return XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
        }
        return null;
    }

    protected Keyword getParameterListOpenParenthesis(XExpression call) {
        if (call instanceof XFeatureCall) {
            return (Keyword)this.grammarAccess.getXFeatureCallAccess().findKeywords(new String[]{"("}).get(0);
        }
        if (call instanceof XMemberFeatureCall) {
            return (Keyword)this.grammarAccess.getXMemberFeatureCallAccess().findKeywords(new String[]{"("}).get(0);
        }
        if (call instanceof XConstructorCall) {
            return (Keyword)this.grammarAccess.getXConstructorCallAccess().findKeywords(new String[]{"("}).get(0);
        }
        return null;
    }
}

