/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;

public class ChannelUID
extends UID {
    public ChannelUID(String channelUid) {
        super(channelUid);
    }

    public ChannelUID(ThingUID thingUID, String id) {
        super(ChannelUID.getArray(thingUID.getBindingId(), thingUID.getThingTypeId(), thingUID.getId(), id, thingUID.getBridgeIds()));
    }

    public ChannelUID(ThingTypeUID thingTypeUID, String thingId, String id) {
        this(thingTypeUID.getBindingId(), thingTypeUID.getId(), thingId, id);
    }

    public ChannelUID(String bindingId, String thingTypeId, String thingId, String id) {
        super(bindingId, thingTypeId, thingId, id);
    }

    private static String[] getArray(String bindingId, String thingTypeId, String thingId, String id, List<String> bridgeIds) {
        if (bridgeIds == null || bridgeIds.size() == 0) {
            return new String[]{bindingId, thingTypeId, thingId, id};
        }
        String[] result = new String[4 + bridgeIds.size()];
        result[0] = bindingId;
        result[1] = thingTypeId;
        int i = 0;
        while (i < bridgeIds.size()) {
            result[i + 2] = bridgeIds.get(i);
            ++i;
        }
        result[result.length - 2] = thingId;
        result[result.length - 1] = id;
        return result;
    }

    public String getThingTypeId() {
        return this.getSegment(1);
    }

    public String getThingId() {
        return this.getSegment(2);
    }

    public List<String> getBridgeIds() {
        ArrayList<String> bridgeIds = new ArrayList<String>();
        String[] segments = this.getSegments();
        int i = 3;
        while (i < segments.length - 1) {
            bridgeIds.add(segments[i]);
            ++i;
        }
        return bridgeIds;
    }

    public String getId() {
        String[] segments = this.getSegments();
        return segments[segments.length - 1];
    }

    @Override
    protected int getMinimalNumberOfSegments() {
        return 4;
    }

    public ThingUID getThingUID() {
        return new ThingUID(Arrays.copyOfRange(this.getSegments(), 0, this.getSegments().length - 1));
    }
}

