/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.builder;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;

public class GenericThingBuilder<T extends GenericThingBuilder<T>> {
    private ThingImpl thing;

    protected GenericThingBuilder(ThingImpl thing) {
        this.thing = thing;
    }

    public T withChannels(Channel ... channels) {
        this.thing.setChannels(Lists.newArrayList((Object[])channels));
        return this.self();
    }

    public T withChannels(List<Channel> channels) {
        this.thing.setChannels(channels);
        return this.self();
    }

    public T withConfiguration(Configuration thingConfiguration) {
        this.thing.setConfiguration(thingConfiguration);
        return this.self();
    }

    public T withBridge(ThingUID bridgeUID) {
        if (bridgeUID != null) {
            this.thing.setBridgeUID(bridgeUID);
        }
        return this.self();
    }

    public Thing build() {
        return this.thing;
    }

    protected T self() {
        return (T)this;
    }
}

