/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class ThingConsoleCommandExtension
implements ConsoleCommandExtension {
    private static final String COMMAND_THINGS = "things";
    private ManagedThingProvider managedThingProvider;
    private ThingRegistry thingRegistry;

    public boolean canHandle(String[] args) {
        String firstArgument = args[0];
        return COMMAND_THINGS.equals(firstArgument);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void execute(String[] args, Console console) {
        String command;
        switch (command = args[0]) {
            case "things": {
                String subCommand;
                Collection things = this.thingRegistry.getAll();
                if (args.length <= 1) {
                    this.printThings(console, things);
                    return;
                }
                switch (subCommand = args[1]) {
                    case "list": {
                        this.printThings(console, things);
                        return;
                    }
                    case "clear": {
                        this.removeAllThings(console, things);
                        return;
                    }
                    case "remove": {
                        if (args.length > 2) {
                            ThingUID thingUID = new ThingUID(args[2]);
                            this.removeThing(console, things, thingUID);
                            return;
                        }
                        console.println("Specify thing id to remove: things remove <thingUID> (e.g. \"hue:light:1\")");
                        return;
                    }
                }
                return;
            }
        }
    }

    private void removeThing(Console console, Collection<Thing> things, ThingUID thingUID) {
        Thing removedThing = (Thing)this.managedThingProvider.remove(thingUID);
        if (removedThing != null) {
            console.println("Thing '" + thingUID + "' successfully removed.");
        } else {
            console.println("Could not delete thing " + thingUID + ".");
        }
    }

    private void removeAllThings(Console console, Collection<Thing> things) {
        int numberOfThings = things.size();
        for (Thing thing : things) {
            this.managedThingProvider.remove(thing.getUID());
        }
        console.println(String.valueOf(numberOfThings) + " things successfully removed.");
    }

    public List<String> getUsages() {
        return Arrays.asList("things list - lists all things", "things clear - removes all managed things", "things remove <thingUID> - removes a thing");
    }

    private void printThings(Console console, Collection<Thing> things) {
        if (things.isEmpty()) {
            console.println("No things found.");
        }
        for (Thing thing : things) {
            String id = thing.getUID().toString();
            String thingType = thing instanceof Bridge ? "Bridge" : "Thing";
            ThingStatus status = thing.getStatus();
            console.println(String.format("%s (Type=%s, Status=%s)", new Object[]{id, thingType, status}));
        }
    }

    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }
}

