/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import org.eclipse.smarthome.core.thing.UID;

public abstract class AbstractDescriptionType {
    private UID uid;
    private String label;
    private String description;
    private URI configDescriptionURI;

    public AbstractDescriptionType(UID uid, String label, String description, URI configDescriptionURI) throws IllegalArgumentException {
        if (uid == null) {
            throw new IllegalArgumentException("The UID must not be null");
        }
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("The label must neither be null nor empty!");
        }
        this.uid = uid;
        this.label = label;
        this.description = description;
        this.configDescriptionURI = configDescriptionURI;
    }

    public UID getUID() {
        return this.uid;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasConfigDescriptionURI() {
        return this.configDescriptionURI != null;
    }

    public URI getConfigDescriptionURI() {
        return this.configDescriptionURI;
    }
}

