/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.validation;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.ui.preferences.ScrolledPageContent;
import org.eclipse.xtext.ui.util.PixelConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatorConfigurationBlock
extends OptionsConfigurationBlock {
    @Inject
    private IDialogSettings section;
    private PixelConverter fPixelConverter;
    @Inject
    @Named(value="languageName")
    private String languageName;

    protected AbstractValidatorConfigurationBlock() {
    }

    @Override
    public Control doCreateContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createStyleTabContent(Composite folder) {
        int nColumns = 3;
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 16448);
        description.setFont(description.getFont());
        description.setText("Select the severity level for the following optional " + this.lastSegment(this.languageName) + " compiler problems:");
        description.setLayoutData((Object)new GridData(1, 2, true, false, nColumns - 1, 1));
        int indentStep = this.fPixelConverter.convertWidthInCharsToPixels(1);
        int defaultIndent = indentStep * 0;
        this.fillSettingsPage(composite, nColumns, defaultIndent);
        new Label(composite, 0);
        this.restoreSectionExpansionStates(this.section);
        return sc1;
    }

    protected void adjustComboWidth(List<Combo> combos) {
        int withHint = -1;
        for (Combo comboBox : combos) {
            comboBox.pack(true);
            Point computeSize = comboBox.computeSize(-1, -1);
            int pixels = computeSize.x;
            if (pixels <= withHint) continue;
            withHint = pixels;
        }
        for (Combo comboBox : combos) {
            Object ld = comboBox.getLayoutData();
            if (!(ld instanceof GridData)) continue;
            GridData layoutData = (GridData)ld;
            layoutData.widthHint = withHint;
        }
    }

    private String lastSegment(String languageFQN) {
        String simplename = languageFQN;
        int lastDot = languageFQN.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < languageFQN.length() - 1) {
            simplename = languageFQN.substring(lastDot + 1, languageFQN.length());
        }
        return simplename;
    }

    protected abstract void fillSettingsPage(Composite var1, int var2, int var3);

    protected Composite createSection(String label, Composite composite, int nColumns) {
        ExpandableComposite excomposite = this.createStyleSection(composite, label, nColumns);
        Composite inner = new Composite((Composite)excomposite, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        excomposite.setClient((Control)inner);
        return inner;
    }
}

