/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActiveService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractActiveService.class);
    private boolean properlyConfigured = false;
    protected boolean shutdown = false;
    private Thread refreshThread;

    public void activate() {
        this.start();
    }

    public void deactivate() {
        this.shutdown();
    }

    protected void start() {
        if (!this.isProperlyConfigured()) {
            logger.trace("{} won't be started because it isn't yet properly configured.", (Object)this.getName());
            return;
        }
        this.shutdown = false;
        if (!this.isRunning()) {
            this.refreshThread = new RefreshThread(this.getName(), this.getRefreshInterval());
            this.refreshThread.start();
        } else {
            logger.trace("{} is already started > calling start() changed nothing.", (Object)this.getName());
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void interrupt() {
        if (this.isRunning()) {
            this.refreshThread.interrupt();
            logger.trace("{} has been interrupted.", (Object)this.getName());
        }
    }

    public boolean isRunning() {
        if (this.refreshThread != null) {
            return this.refreshThread.isAlive();
        }
        return false;
    }

    public final boolean isProperlyConfigured() {
        return this.properlyConfigured;
    }

    public void setProperlyConfigured(boolean properlyConfigured) {
        this.properlyConfigured = properlyConfigured;
        if (properlyConfigured && !this.isRunning()) {
            this.start();
        } else if (!properlyConfigured && this.isRunning()) {
            this.shutdown();
        }
    }

    protected abstract void execute();

    protected abstract long getRefreshInterval();

    protected abstract String getName();

    class RefreshThread
    extends Thread {
        private long refreshInterval;

        public RefreshThread(String name, long refreshInterval) {
            super(name);
            this.setDaemon(true);
            this.refreshInterval = refreshInterval;
            AbstractActiveService.this.shutdown = false;
        }

        @Override
        public void run() {
            logger.info(String.valueOf(this.getName()) + " has been started");
            while (!AbstractActiveService.this.shutdown) {
                try {
                    AbstractActiveService.this.execute();
                }
                catch (RuntimeException e) {
                    logger.error("Error while executing background thread " + this.getName(), (Throwable)e);
                }
                this.pause(this.refreshInterval);
            }
            AbstractActiveService.this.refreshThread = null;
            logger.info(String.valueOf(this.getName()) + " has been shut down");
        }

        protected void pause(long refreshInterval) {
            try {
                Thread.sleep(refreshInterval);
            }
            catch (InterruptedException interruptedException) {
                logger.debug("pausing thread " + super.getName() + " interrupted");
            }
        }
    }
}

