/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkProvider;
import org.eclipse.smarthome.model.item.BindingConfigParseException;
import org.eclipse.smarthome.model.item.BindingConfigReader;

public class GenericItemChannelLinkProvider
extends AbstractProvider<ItemChannelLink>
implements BindingConfigReader,
ItemChannelLinkProvider {
    protected Map<String, ItemChannelLink> itemChannelLinkMap = new ConcurrentHashMap<String, ItemChannelLink>(new WeakHashMap());
    protected Map<String, Set<String>> contextMap = new ConcurrentHashMap<String, Set<String>>();

    public String getBindingType() {
        return "channel";
    }

    public void validateItemType(String itemType, String bindingConfig) throws BindingConfigParseException {
    }

    public void processBindingConfiguration(String context, String itemType, String itemName, String bindingConfig) throws BindingConfigParseException {
        ChannelUID channelUID = null;
        try {
            channelUID = new ChannelUID(bindingConfig);
        }
        catch (IllegalArgumentException e) {
            throw new BindingConfigParseException(e.getMessage());
        }
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUID);
        Set<String> itemNames = this.contextMap.get(context);
        if (itemNames == null) {
            itemNames = new HashSet<String>();
            this.contextMap.put(context, itemNames);
        }
        itemNames.add(itemName);
        ItemChannelLink oldItemChannelLink = this.itemChannelLinkMap.put(itemName, itemChannelLink);
        if (oldItemChannelLink == null) {
            this.notifyListenersAboutAddedElement(itemChannelLink);
        } else {
            this.notifyListenersAboutUpdatedElement(oldItemChannelLink, itemChannelLink);
        }
    }

    public void removeConfigurations(String context) {
        Set<String> itemNames = this.contextMap.get(context);
        if (itemNames != null) {
            for (String itemName : itemNames) {
                ItemChannelLink removedItemChannelLink = this.itemChannelLinkMap.remove(itemName);
                this.notifyListenersAboutRemovedElement(removedItemChannelLink);
            }
            this.contextMap.remove(context);
        }
    }

    public Collection<ItemChannelLink> getAll() {
        return this.itemChannelLinkMap.values();
    }
}

