/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.util.ThingHelper;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelPropertyContainer;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericThingProvider
extends AbstractProvider<Thing>
implements ThingProvider,
ModelRepositoryChangeListener {
    private ModelRepository modelRepository;
    private ThingTypeRegistry thingTypeRegistry;
    private Map<String, Collection<Thing>> thingsMap = new ConcurrentHashMap<String, Collection<Thing>>();
    private static final Logger logger = LoggerFactory.getLogger(GenericThingProvider.class);

    public void activate() {
        Iterable _allModelNamesOfType = this.modelRepository.getAllModelNamesOfType("things");
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                GenericThingProvider.this.createThingsFromModel(it);
            }
        };
        IterableExtensions.forEach((Iterable)_allModelNamesOfType, (Procedures.Procedure1)_function);
    }

    public Collection<Thing> getAll() {
        Collection<Collection<Thing>> _values = this.thingsMap.values();
        Iterable _flatten = Iterables.concat(_values);
        return IterableExtensions.toList((Iterable)_flatten);
    }

    private void createThingsFromModel(String modelName) {
        boolean _isEmpty;
        boolean _notEquals;
        logger.debug("Read things from model '{}'", (Object)modelName);
        final ArrayList things = CollectionLiterals.newArrayList((Object[])new Thing[0]);
        boolean bl = _notEquals = !Objects.equal((Object)this.modelRepository, null);
        if (_notEquals) {
            boolean _notEquals_1;
            EObject _model = this.modelRepository.getModel(modelName);
            ThingModel model = (ThingModel)_model;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)model, null);
            if (_notEquals_1) {
                EList<ModelThing> _things = model.getThings();
                Procedures.Procedure1<ModelThing> _function = new Procedures.Procedure1<ModelThing>(){

                    public void apply(ModelThing it) {
                        GenericThingProvider.this.createThing(it, null, things);
                    }
                };
                IterableExtensions.forEach(_things, (Procedures.Procedure1)_function);
            }
        }
        if (_isEmpty = things.isEmpty()) {
            this.thingsMap.remove(modelName);
        } else {
            this.thingsMap.put(modelName, things);
        }
    }

    private void createThing(ModelThing modelThing, Bridge parentBridge, final List<Thing> thingList) {
        boolean _notEquals_1;
        boolean _notEquals;
        ThingTypeUID thingTypeUID = null;
        ThingUID thingUID = null;
        boolean bl = _notEquals = !Objects.equal((Object)parentBridge, null);
        if (_notEquals) {
            ThingUID _thingUID;
            ThingTypeUID _thingTypeUID_1;
            ThingTypeUID _thingTypeUID = parentBridge.getThingTypeUID();
            String bindingId = _thingTypeUID.getBindingId();
            String thingTypeId = modelThing.getThingTypeId();
            String thingId = modelThing.getThingId();
            thingTypeUID = _thingTypeUID_1 = new ThingTypeUID(bindingId, thingTypeId);
            List<String> _parentPath = this.getParentPath(parentBridge);
            thingUID = _thingUID = new ThingUID(thingTypeUID, thingId, (String[])Conversions.unwrapArray(_parentPath, String.class));
        } else {
            ThingTypeUID _thingTypeUID_2;
            ThingUID _thingUID_1;
            String _id = modelThing.getId();
            thingUID = _thingUID_1 = new ThingUID(_id);
            String _bindingId = thingUID.getBindingId();
            String _thingTypeId = thingUID.getThingTypeId();
            thingTypeUID = _thingTypeUID_2 = new ThingTypeUID(_bindingId, _thingTypeId);
        }
        logger.debug("Creating thing for type '{}' with UID '{}.", (Object)thingTypeUID, (Object)thingUID);
        Configuration configuration = this.createConfiguration(modelThing);
        Object _xifexpression = null;
        _xifexpression = modelThing instanceof ModelBridge ? BridgeBuilder.create((ThingUID)thingUID) : ThingBuilder.create((ThingUID)thingUID);
        BridgeBuilder thingBuilder = _xifexpression;
        thingBuilder.withConfiguration(configuration);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)parentBridge, null);
        if (_notEquals_1) {
            ThingUID _uID = parentBridge.getUID();
            thingBuilder.withBridge(_uID);
        }
        ThingType thingType = this.getThingType(thingTypeUID);
        EList<ModelChannel> _channels = modelThing.getChannels();
        List _elvis = null;
        List _channelDefinitions = null;
        if (thingType != null) {
            _channelDefinitions = thingType.getChannelDefinitions();
        }
        if (_channelDefinitions != null) {
            _elvis = _channelDefinitions;
        } else {
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new ChannelDefinition[0]);
            _elvis = _newArrayList;
        }
        List<Channel> channels = this.createChannels(thingUID, (List<ModelChannel>)_channels, _elvis);
        thingBuilder.withChannels(channels);
        final Thing thing = thingBuilder.build();
        thingList.add(thing);
        if (modelThing instanceof ModelBridge) {
            EList<ModelThing> _things = ((ModelBridge)modelThing).getThings();
            Procedures.Procedure1<ModelThing> _function = new Procedures.Procedure1<ModelThing>(){

                public void apply(ModelThing it) {
                    GenericThingProvider.this.createThing(it, (Bridge)thing, thingList);
                }
            };
            IterableExtensions.forEach(_things, (Procedures.Procedure1)_function);
        }
    }

    private List<String> getParentPath(Bridge bridge) {
        ThingUID _uID = bridge.getUID();
        List bridgeIds = _uID.getBridgeIds();
        ThingUID _uID_1 = bridge.getUID();
        String _id = _uID_1.getId();
        bridgeIds.add(_id);
        return bridgeIds;
    }

    private List<Channel> createChannels(final ThingUID thingUID, List<ModelChannel> modelChannels, List<ChannelDefinition> channelDefinitions) {
        ArrayList _xblockexpression = null;
        final HashSet addedChannelIds = CollectionLiterals.newHashSet((Object[])new String[0]);
        final ArrayList channels = CollectionLiterals.newArrayList((Object[])new Channel[0]);
        Procedures.Procedure1<ModelChannel> _function = new Procedures.Procedure1<ModelChannel>(){

            public void apply(ModelChannel it) {
                String _id = it.getId();
                boolean _add = addedChannelIds.add(_id);
                if (_add) {
                    String _id_1 = it.getId();
                    ChannelUID _channelUID = new ChannelUID(thingUID, _id_1);
                    String _type = it.getType();
                    ChannelBuilder _create = ChannelBuilder.create((ChannelUID)_channelUID, (String)_type);
                    Configuration _createConfiguration = GenericThingProvider.this.createConfiguration(it);
                    ChannelBuilder _withConfiguration = _create.withConfiguration(_createConfiguration);
                    Channel _build = _withConfiguration.build();
                    channels.add(_build);
                }
            }
        };
        IterableExtensions.forEach(modelChannels, (Procedures.Procedure1)_function);
        Procedures.Procedure1<ChannelDefinition> _function_1 = new Procedures.Procedure1<ChannelDefinition>(){

            public void apply(ChannelDefinition it) {
                String _id = it.getId();
                boolean _add = addedChannelIds.add(_id);
                if (_add) {
                    String _id_1 = it.getId();
                    ChannelUID _channelUID = new ChannelUID(thingUID, _id_1);
                    ChannelType _type = it.getType();
                    String _itemType = _type.getItemType();
                    ChannelBuilder _create = ChannelBuilder.create((ChannelUID)_channelUID, (String)_itemType);
                    Channel _build = _create.build();
                    channels.add(_build);
                }
            }
        };
        IterableExtensions.forEach(channelDefinitions, (Procedures.Procedure1)_function_1);
        _xblockexpression = channels;
        return _xblockexpression;
    }

    private Configuration createConfiguration(ModelPropertyContainer propertyContainer) {
        Configuration _xblockexpression = null;
        final Configuration configuration = new Configuration();
        EList<ModelProperty> _properties = propertyContainer.getProperties();
        Procedures.Procedure1<ModelProperty> _function = new Procedures.Procedure1<ModelProperty>(){

            public void apply(ModelProperty it) {
                String _key = it.getKey();
                Object _value = it.getValue();
                configuration.put(_key, _value);
            }
        };
        IterableExtensions.forEach(_properties, (Procedures.Procedure1)_function);
        _xblockexpression = configuration;
        return _xblockexpression;
    }

    private ThingType getThingType(ThingTypeUID thingTypeUID) {
        ThingType _thingType = null;
        if (this.thingTypeRegistry != null) {
            _thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        }
        return _thingType;
    }

    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void modelChanged(String modelName, EventType type) {
        boolean _endsWith = modelName.endsWith("things");
        if (_endsWith && type != null) {
            switch (type) {
                case ADDED: {
                    ArrayList _newArrayList;
                    this.createThingsFromModel(modelName);
                    ArrayList _elvis = null;
                    ArrayList _get = this.thingsMap.get(modelName);
                    _elvis = _get != null ? _get : (_newArrayList = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList things = _elvis;
                    Procedures.Procedure1<Thing> _function = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutAddedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)things, (Procedures.Procedure1)_function);
                    break;
                }
                case MODIFIED: {
                    ArrayList _newArrayList_2;
                    ArrayList _newArrayList_1;
                    ArrayList _elvis_1 = null;
                    ArrayList _get_1 = this.thingsMap.get(modelName);
                    _elvis_1 = _get_1 != null ? _get_1 : (_newArrayList_1 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    final ArrayList oldThings = _elvis_1;
                    Functions.Function1<Thing, ThingUID> _function_1 = new Functions.Function1<Thing, ThingUID>(){

                        public ThingUID apply(Thing it) {
                            return it.getUID();
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)oldThings, (Functions.Function1)_function_1);
                    final List oldThingsUIDs = IterableExtensions.toList((Iterable)_map);
                    this.createThingsFromModel(modelName);
                    ArrayList _elvis_2 = null;
                    ArrayList _get_2 = this.thingsMap.get(modelName);
                    _elvis_2 = _get_2 != null ? _get_2 : (_newArrayList_2 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList currentThings = _elvis_2;
                    Functions.Function1<Thing, ThingUID> _function_2 = new Functions.Function1<Thing, ThingUID>(){

                        public ThingUID apply(Thing it) {
                            return it.getUID();
                        }
                    };
                    Iterable _map_1 = IterableExtensions.map((Iterable)currentThings, (Functions.Function1)_function_2);
                    final List currentThingUIDs = IterableExtensions.toList((Iterable)_map_1);
                    Functions.Function1<Thing, Boolean> _function_3 = new Functions.Function1<Thing, Boolean>(){

                        public Boolean apply(Thing it) {
                            ThingUID _uID = it.getUID();
                            boolean _contains = currentThingUIDs.contains(_uID);
                            return !_contains;
                        }
                    };
                    Iterable removedThings = IterableExtensions.filter((Iterable)oldThings, (Functions.Function1)_function_3);
                    Functions.Function1<Thing, Boolean> _function_4 = new Functions.Function1<Thing, Boolean>(){

                        public Boolean apply(Thing it) {
                            ThingUID _uID = it.getUID();
                            boolean _contains = oldThingsUIDs.contains(_uID);
                            return !_contains;
                        }
                    };
                    Iterable addedThings = IterableExtensions.filter((Iterable)currentThings, (Functions.Function1)_function_4);
                    Procedures.Procedure1<Thing> _function_5 = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutRemovedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)removedThings, (Procedures.Procedure1)_function_5);
                    Procedures.Procedure1<Thing> _function_6 = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutAddedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)addedThings, (Procedures.Procedure1)_function_6);
                    Procedures.Procedure1<Thing> _function_7 = new Procedures.Procedure1<Thing>(){

                        public void apply(final Thing newThing) {
                            Procedures.Procedure1<Thing> _function = new Procedures.Procedure1<Thing>(){

                                public void apply(Thing oldThing) {
                                    ThingUID _uID_1;
                                    ThingUID _uID = newThing.getUID();
                                    boolean _equals = Objects.equal((Object)_uID, (Object)(_uID_1 = oldThing.getUID()));
                                    if (_equals) {
                                        boolean _not;
                                        boolean _equals_1 = ThingHelper.equals((Thing)oldThing, (Thing)newThing);
                                        boolean bl = _not = !_equals_1;
                                        if (_not) {
                                            GenericThingProvider.this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                                        }
                                    }
                                }
                            };
                            IterableExtensions.forEach((Iterable)oldThings, (Procedures.Procedure1)_function);
                        }
                    };
                    IterableExtensions.forEach((Iterable)currentThings, (Procedures.Procedure1)_function_7);
                    break;
                }
                case REMOVED: {
                    ArrayList _newArrayList_3;
                    ArrayList _elvis_3 = null;
                    ArrayList _remove = this.thingsMap.remove(modelName);
                    _elvis_3 = _remove != null ? _remove : (_newArrayList_3 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList things_1 = _elvis_3;
                    Procedures.Procedure1<Thing> _function_8 = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutRemovedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)things_1, (Procedures.Procedure1)_function_8);
                    break;
                }
            }
        }
    }

    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }
}

