/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import org.eclipse.smarthome.core.events.AbstractEventSubscriber;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemUpdater
extends AbstractEventSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(ItemUpdater.class);
    protected ItemRegistry itemRegistry;

    public ItemUpdater() {
        this.getSourceFilterList().clear();
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Override
    public void receiveUpdate(String itemName, State newStatus) {
        if (this.itemRegistry != null) {
            try {
                GenericItem item = (GenericItem)this.itemRegistry.getItem(itemName);
                boolean isAccepted = false;
                if (item.getAcceptedDataTypes().contains(newStatus.getClass())) {
                    isAccepted = true;
                } else {
                    for (Class<? extends State> state : item.getAcceptedDataTypes()) {
                        try {
                            if (state.isEnum() || !state.newInstance().getClass().isAssignableFrom(newStatus.getClass())) continue;
                            isAccepted = true;
                            break;
                        }
                        catch (InstantiationException e) {
                            logger.warn("InstantiationException on {}", (Object)e.getMessage());
                        }
                        catch (IllegalAccessException e) {
                            logger.warn("IllegalAccessException on {}", (Object)e.getMessage());
                        }
                    }
                }
                if (isAccepted) {
                    item.setState(newStatus);
                } else {
                    logger.debug("Received update of a not accepted type (" + newStatus.getClass().getSimpleName() + ") for item " + itemName);
                }
            }
            catch (ItemNotFoundException e) {
                logger.debug("Received update for non-existing item: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void receiveCommand(String itemName, Command command) {
        if (this.itemRegistry != null) {
            try {
                Item item = this.itemRegistry.getItem(itemName);
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    groupItem.send(command);
                }
            }
            catch (ItemNotFoundException e) {
                logger.debug("Received command for non-existing item: {}", (Object)e.getMessage());
            }
        }
    }
}

