/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.MoveResourcesProcessor;

public final class MoveResourcesDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.ltk.core.refactoring.move.resources";
    private IPath fDestinationPath = null;
    private IPath[] fResourcePathsToMove = null;
    private boolean fUpdateReferences = true;

    public MoveResourcesDescriptor() {
        super(ID, null, RefactoringCoreMessages.MoveResourcesDescriptor_unnamed_descriptor, null, 6);
    }

    public void setDestination(IContainer container) {
        Assert.isNotNull((Object)container);
        this.fDestinationPath = container.getFullPath();
    }

    public void setDestinationPath(IPath path) {
        Assert.isNotNull((Object)path);
        this.fDestinationPath = path;
    }

    public IPath getDestinationPath() {
        return this.fDestinationPath;
    }

    public void setResourcePathsToMove(IPath[] resourcePaths) {
        if (resourcePaths == null) {
            throw new IllegalArgumentException(RefactoringCoreMessages.MoveResourcesDescriptor_error_empty_array);
        }
        this.fResourcePathsToMove = resourcePaths;
    }

    public void setResourcesToMove(IResource[] resources) {
        if (resources == null) {
            throw new IllegalArgumentException(RefactoringCoreMessages.MoveResourcesDescriptor_error_empty_array);
        }
        IPath[] paths = new IPath[resources.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = resources[i].getFullPath();
            ++i;
        }
        this.setResourcePathsToMove(paths);
    }

    public IPath[] getResourcePathsToMove() {
        return this.fResourcePathsToMove;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath destinationPath = this.getDestinationPath();
        if (destinationPath == null) {
            status.addFatalError(RefactoringCoreMessages.MoveResourcesDescriptor_error_destination_not_set);
            return null;
        }
        IResource destination = root.findMember(destinationPath);
        if (!(destination instanceof IFolder) && !(destination instanceof IProject) || !destination.exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.MoveResourcesDescriptor_error_destination_not_exists, BasicElementLabels.getPathLabel(destinationPath, false)));
            return null;
        }
        IPath[] paths = this.getResourcePathsToMove();
        if (paths == null) {
            status.addFatalError(RefactoringCoreMessages.MoveResourcesDescriptor_error_moved_not_set);
            return null;
        }
        IResource[] resources = new IResource[paths.length];
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            if (path == null) {
                status.addFatalError(RefactoringCoreMessages.MoveResourcesDescriptor_error_moved_contains_null);
                return null;
            }
            IResource resource = root.findMember(path);
            if (resource == null || !resource.exists()) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.MoveResourcesDescriptor_error_moved_not_exists, BasicElementLabels.getPathLabel(path, false)));
                return null;
            }
            if (!(resource instanceof IFile) && !(resource instanceof IFolder)) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.MoveResourcesDescriptor_error_moved_not_file_or_folder, BasicElementLabels.getPathLabel(path, false)));
                return null;
            }
            resources[i] = resource;
            ++i;
        }
        MoveResourcesProcessor processor = new MoveResourcesProcessor(resources);
        processor.setDestination((IContainer)destination);
        processor.setUpdateReferences(this.isUpdateReferences());
        return new MoveRefactoring(processor);
    }
}

